/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.Jets3tNativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public class NativeS3FileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(NativeS3FileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    static final String PATH_DELIMITER = "/";
    private static final int S3_MAX_LISTING_LENGTH = 1000;
    private URI uri;
    private NativeFileSystemStore store;
    private Path workingDir;

    public NativeS3FileSystem() {
    }

    public NativeS3FileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    public String getScheme() {
        return "s3n";
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        if (this.store == null) {
            this.store = NativeS3FileSystem.createDefaultStore((Configuration)conf);
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
    }

    private static NativeFileSystemStore createDefaultStore(Configuration conf) {
        Jets3tNativeFileSystemStore store = new Jets3tNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.s3.maxRetries", 4), (long)conf.getLong("fs.s3.sleepTimeSeconds", 10L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class, RetryPolicy> exceptionToPolicyMap = new HashMap<Class, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        exceptionToPolicyMap.put(S3Exception.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("storeFile", methodPolicy);
        methodNameToPolicyMap.put("rename", methodPolicy);
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, methodNameToPolicyMap);
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath().substring(1);
        if (ret.endsWith("/") && ret.indexOf("/") != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        return new Path("/" + key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new file '" + f + "' in S3");
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey((Path)absolutePath);
        return new FSDataOutputStream((OutputStream)new NativeS3FsOutputStream(this, this.getConf(), this.store, key, progress, bufferSize), this.statistics);
    }

    public boolean delete(Path f, boolean recurse) throws IOException {
        FileStatus status;
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delete called for '" + f + "' but file does not exist, so returning false");
            }
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey((Path)absolutePath);
        if (status.isDirectory()) {
            PartialListing listing;
            if (!recurse && this.listStatus(f).length > 0) {
                throw new IOException("Can not delete " + f + " as is a not empty directory and recurse option is false");
            }
            this.createParent(f);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting directory '" + f + "'");
            }
            String priorLastKey = null;
            do {
                listing = this.store.list(key, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    this.store.delete(file.getKey());
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            try {
                this.store.delete(key + "_$folder$");
            }
            catch (FileNotFoundException e) {}
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting file '" + f + "'");
            }
            this.createParent(f);
            this.store.delete(key);
        }
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey((Path)absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus retrieving metadata for key '" + key + "'");
        }
        if ((meta = this.store.retrieveMetadata(key)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'file' for key '" + key + "'");
            }
            return this.newFile(meta, absolutePath);
        }
        if (this.store.retrieveMetadata(key + "_$folder$") != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as '" + key + "_$folder$" + "' exists");
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus listing key '" + key + "'");
        }
        if ((listing = this.store.list(key, 1)).getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as it has contents");
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus could not find key '" + key + "'");
        }
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey((Path)absolutePath);
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null) {
            return new FileStatus[]{this.newFile(meta, absolutePath)};
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            String relativePath;
            Path subpath;
            listing = this.store.list(key, 1000, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subpath = NativeS3FileSystem.keyToPath((String)fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                if (fileMetadata.getKey().equals(key + "/")) continue;
                if (relativePath.endsWith("_$folder$")) {
                    status.add(this.newDirectory(new Path(absolutePath, relativePath.substring(0, relativePath.indexOf("_$folder$")))));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath));
            }
            for (String string : listing.getCommonPrefixes()) {
                subpath = NativeS3FileSystem.keyToPath((String)string);
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        if (status.isEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + "_$folder$") == null) {
            throw new FileNotFoundException("File " + f + " does not exist.");
        }
        return status.toArray(new FileStatus[status.size()]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(Path path) {
        return new FileStatus(0L, true, 1, 0L, 0L, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(0, absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        boolean result = true;
        for (Path path : paths) {
            result &= this.mkdir(path);
        }
        return result;
    }

    private boolean mkdir(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isFile()) {
                throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", f));
            }
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Making dir '" + f + "' in S3");
            }
            String key = NativeS3FileSystem.pathToKey((Path)f) + "_$folder$";
            this.store.storeEmptyFile(key);
        }
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fs = this.getFileStatus(f);
        if (fs.isDirectory()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.info("Opening '" + f + "' for reading");
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey((Path)absolutePath);
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new NativeS3FsInputStream(this.store, this.statistics, this.store.retrieve(key), key), bufferSize));
    }

    private void createParent(Path path) throws IOException {
        String key;
        Path parent = path.getParent();
        if (parent != null && (key = NativeS3FileSystem.pathToKey((Path)this.makeAbsolute(parent))).length() > 0) {
            this.store.storeEmptyFile(key + "_$folder$");
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcIsFile;
        String dstKey;
        String srcKey = NativeS3FileSystem.pathToKey((Path)this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        String debugPreamble = "Renaming '" + src + "' to '" + dst + "' - ";
        try {
            boolean dstIsFile = this.getFileStatus(dst).isFile();
            if (dstIsFile) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst is an already existing file");
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output directory");
            }
            dstKey = NativeS3FileSystem.pathToKey((Path)this.makeAbsolute(new Path(dst, src.getName())));
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output destination");
            }
            dstKey = NativeS3FileSystem.pathToKey((Path)this.makeAbsolute(dst));
            try {
                if (this.getFileStatus(dst.getParent()).isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(debugPreamble + "returning false as dst parent exists and is a file");
                    }
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst parent does not exist");
                }
                return false;
            }
        }
        try {
            srcIsFile = this.getFileStatus(src).isFile();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "returning false as src does not exist");
            }
            return false;
        }
        if (srcIsFile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is file, so doing copy then delete in S3");
            }
            this.store.copy(srcKey, dstKey);
            this.store.delete(srcKey);
        } else {
            PartialListing listing;
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is directory, so copying contents");
            }
            this.store.storeEmptyFile(dstKey + "_$folder$");
            ArrayList<String> keysToDelete = new ArrayList<String>();
            String priorLastKey = null;
            do {
                listing = this.store.list(srcKey, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    keysToDelete.add(file.getKey());
                    this.store.copy(file.getKey(), dstKey + file.getKey().substring(srcKey.length()));
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "all files in src copied, now removing src files");
            }
            for (String key : keysToDelete) {
                this.store.delete(key);
            }
            try {
                this.store.delete(srcKey + "_$folder$");
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "done");
            }
        }
        return true;
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.s3n.block.size", 0x4000000L);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getCanonicalServiceName() {
        return null;
    }

    static /* synthetic */ NativeFileSystemStore access$000(NativeS3FileSystem x0) {
        return x0.store;
    }
}

