/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AOutputStream;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

public class S3AOutputStream
extends OutputStream {
    private OutputStream backupStream;
    private File backupFile;
    private boolean closed;
    private String key;
    private String bucket;
    private TransferManager transfers;
    private Progressable progress;
    private long partSize;
    private int partSizeThreshold;
    private S3AFileSystem fs;
    private CannedAccessControlList cannedACL;
    private FileSystem.Statistics statistics;
    private LocalDirAllocator lDirAlloc;
    private String serverSideEncryptionAlgorithm;
    public static final Logger LOG = S3AFileSystem.LOG;

    public S3AOutputStream(Configuration conf, TransferManager transfers, S3AFileSystem fs, String bucket, String key, Progressable progress, CannedAccessControlList cannedACL, FileSystem.Statistics statistics, String serverSideEncryptionAlgorithm) throws IOException {
        this.bucket = bucket;
        this.key = key;
        this.transfers = transfers;
        this.progress = progress;
        this.fs = fs;
        this.cannedACL = cannedACL;
        this.statistics = statistics;
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
        this.partSize = conf.getLong("fs.s3a.multipart.size", 0x6400000L);
        this.partSizeThreshold = conf.getInt("fs.s3a.multipart.threshold", Integer.MAX_VALUE);
        this.lDirAlloc = conf.get("fs.s3a.buffer.dir", null) != null ? new LocalDirAllocator("fs.s3a.buffer.dir") : new LocalDirAllocator("${hadoop.tmp.dir}/s3a");
        this.backupFile = this.lDirAlloc.createTmpFileForWrite("output-", -1L, conf);
        this.closed = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("OutputStream for key '" + key + "' writing to tempfile: " + this.backupFile);
        }
        this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
    }

    @Override
    public void flush() throws IOException {
        this.backupStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.backupStream.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("OutputStream for key '" + this.key + "' closed. Now beginning upload");
            LOG.debug("Minimum upload part size: " + this.partSize + " threshold " + this.partSizeThreshold);
        }
        try {
            ObjectMetadata om = new ObjectMetadata();
            if (StringUtils.isNotBlank((String)this.serverSideEncryptionAlgorithm)) {
                om.setServerSideEncryption(this.serverSideEncryptionAlgorithm);
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, this.key, this.backupFile);
            putObjectRequest.setCannedAcl(this.cannedACL);
            putObjectRequest.setMetadata(om);
            Upload upload = this.transfers.upload(putObjectRequest);
            ProgressableProgressListener listener = new ProgressableProgressListener(upload, this.progress, this.statistics);
            upload.addProgressListener((ProgressListener)listener);
            upload.waitForUploadResult();
            long delta = upload.getProgress().getBytesTransferred() - listener.getLastBytesTransferred();
            if (this.statistics != null && delta != 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("S3A write delta changed after finished: " + delta + " bytes");
                }
                this.statistics.incrementBytesWritten(delta);
            }
            this.fs.finishedWrite(this.key);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            if (!this.backupFile.delete()) {
                LOG.warn("Could not delete temporary s3a file: {}", (Object)this.backupFile);
            }
            super.close();
            this.closed = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OutputStream for key '" + this.key + "' upload complete");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.backupStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.backupStream.write(b, off, len);
    }
}

