/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.AuthToken;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthToken {
    @Test
    public void testConstructor() throws Exception {
        try {
            new AuthToken(null, "p", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthToken("", "p", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthToken("u", null, "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthToken("u", "", "t");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthToken("u", "p", null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        try {
            new AuthToken("u", "p", "");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
        new AuthToken("u", "p", "t");
    }

    @Test
    public void testGetters() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        Assert.assertEquals((Object)"u", (Object)token.getUserName());
        Assert.assertEquals((Object)"p", (Object)token.getName());
        Assert.assertEquals((Object)"t", (Object)token.getType());
        Assert.assertEquals((long)expires, (long)token.getExpires());
        Assert.assertFalse((boolean)token.isExpired());
        Thread.sleep(70L);
        Assert.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testToStringAndParse() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        String str = token.toString();
        token = AuthToken.parse((String)str);
        Assert.assertEquals((Object)"p", (Object)token.getName());
        Assert.assertEquals((Object)"t", (Object)token.getType());
        Assert.assertEquals((long)expires, (long)token.getExpires());
        Assert.assertFalse((boolean)token.isExpired());
        Thread.sleep(70L);
        Assert.assertTrue((boolean)token.isExpired());
    }

    @Test
    public void testParseValidAndInvalid() throws Exception {
        long expires = System.currentTimeMillis() + 50L;
        AuthToken token = new AuthToken("u", "p", "t");
        token.setExpires(expires);
        String ostr = token.toString();
        String str1 = "\"" + ostr + "\"";
        AuthToken.parse((String)str1);
        String str2 = ostr + "&s=1234";
        AuthToken.parse((String)str2);
        String str = ostr.substring(0, ostr.indexOf("e="));
        try {
            AuthToken.parse((String)str);
            Assert.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }
}

