/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestKerberosUtil {
    static String testKeytab = "test.keytab";
    static String[] testPrincipals = new String[]{"HTTP@testRealm", "test/testhost@testRealm", "HTTP/testhost@testRealm", "HTTP1/testhost@testRealm", "HTTP/testhostanother@testRealm"};

    @After
    public void deleteKeytab() {
        File keytabFile = new File(testKeytab);
        if (keytabFile.exists()) {
            keytabFile.delete();
        }
    }

    @Test
    public void testGetServerPrincipal() throws IOException {
        String service = "TestKerberosUtil";
        String localHostname = KerberosUtil.getLocalHostName();
        String testHost = "FooBar";
        Assert.assertEquals((String)"When no hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, null));
        Assert.assertEquals((String)"When empty hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)""));
        Assert.assertEquals((String)"When 0.0.0.0 hostname is sent", (Object)(service + "/" + localHostname.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)"0.0.0.0"));
        Assert.assertEquals((String)"When uppercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost));
        Assert.assertEquals((String)"When lowercase hostname is sent", (Object)(service + "/" + testHost.toLowerCase()), (Object)KerberosUtil.getServicePrincipal((String)service, (String)testHost.toLowerCase()));
    }

    @Test
    public void testGetPrincipalNamesMissingKeytab() {
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesMissingPattern() throws IOException {
        this.createKeyTab(testKeytab, new String[]{"test/testhost@testRealm"});
        try {
            KerberosUtil.getPrincipalNames((String)testKeytab, null);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetPrincipalNamesFromKeytab() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        String[] principals = KerberosUtil.getPrincipalNames((String)testKeytab);
        Assert.assertNotNull((String)"principals cannot be null", (Object)principals);
        int expectedSize = 0;
        List<String> principalList = Arrays.asList(principals);
        for (String principal : testPrincipals) {
            Assert.assertTrue((String)("missing principal " + principal), (boolean)principalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)principals.length);
    }

    @Test
    public void testGetPrincipalNamesFromKeytabWithPattern() throws IOException {
        this.createKeyTab(testKeytab, testPrincipals);
        Pattern httpPattern = Pattern.compile("HTTP/.*");
        String[] httpPrincipals = KerberosUtil.getPrincipalNames((String)testKeytab, (Pattern)httpPattern);
        Assert.assertNotNull((String)"principals cannot be null", (Object)httpPrincipals);
        int expectedSize = 0;
        List<String> httpPrincipalList = Arrays.asList(httpPrincipals);
        for (String principal : testPrincipals) {
            if (!httpPattern.matcher(principal).matches()) continue;
            Assert.assertTrue((String)("missing principal " + principal), (boolean)httpPrincipalList.contains(principal));
            ++expectedSize;
        }
        Assert.assertEquals((long)expectedSize, (long)httpPrincipals.length);
    }

    private void createKeyTab(String fileName, String[] principalNames) throws IOException {
        ArrayList<KeytabEntry> lstEntries = new ArrayList<KeytabEntry>();
        for (String principal : principalNames) {
            for (int kvno = 1; kvno <= 3; ++kvno) {
                EncryptionKey key = new EncryptionKey(EncryptionType.UNKNOWN, "samplekey1".getBytes(), kvno);
                KeytabEntry keytabEntry = new KeytabEntry(principal, 1L, new KerberosTime(), 1, key);
                lstEntries.add(keytabEntry);
            }
        }
        Keytab keytab = Keytab.getInstance();
        keytab.setEntries(lstEntries);
        keytab.write(new File(testKeytab));
    }
}

