/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestPseudoAuthenticationHandler
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInit() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "false");
            handler.init(props);
            TestPseudoAuthenticationHandler.assertEquals((boolean)false, (boolean)handler.getAcceptAnonymous());
        }
        finally {
            handler.destroy();
        }
    }

    public void testType() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        TestPseudoAuthenticationHandler.assertEquals((String)"simple", (String)handler.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnonymousOn() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "true");
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            AuthenticationToken token = handler.authenticate(request, response);
            TestPseudoAuthenticationHandler.assertEquals((Object)AuthenticationToken.ANONYMOUS, (Object)token);
        }
        finally {
            handler.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnonymousOff() throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", "false");
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            handler.authenticate(request, response);
            TestPseudoAuthenticationHandler.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            TestPseudoAuthenticationHandler.fail();
        }
        finally {
            handler.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testUserName(boolean anonymous) throws Exception {
        PseudoAuthenticationHandler handler = new PseudoAuthenticationHandler();
        try {
            Properties props = new Properties();
            props.setProperty("simple.anonymous.allowed", Boolean.toString(anonymous));
            handler.init(props);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"user.name=user");
            AuthenticationToken token = handler.authenticate(request, response);
            TestPseudoAuthenticationHandler.assertNotNull((Object)token);
            TestPseudoAuthenticationHandler.assertEquals((String)"user", (String)token.getUserName());
            TestPseudoAuthenticationHandler.assertEquals((String)"user", (String)token.getName());
            TestPseudoAuthenticationHandler.assertEquals((String)"simple", (String)token.getType());
        }
        finally {
            handler.destroy();
        }
    }

    public void testUserNameAnonymousOff() throws Exception {
        this._testUserName(false);
    }

    public void testUserNameAnonymousOn() throws Exception {
        this._testUserName(true);
    }
}

