/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.TestAuthenticationFilter;
import org.apache.hadoop.security.authentication.util.Signer;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAuthenticationFilter
extends TestCase {
    public void testGetConfiguration() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"");
        Mockito.when((Object)config.getInitParameter("a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("a")).elements());
        Properties props = filter.getConfiguration("", config);
        TestAuthenticationFilter.assertEquals((String)"A", (String)props.getProperty("a"));
        config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"foo");
        Mockito.when((Object)config.getInitParameter("foo.a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("foo.a")).elements());
        props = filter.getConfiguration("foo.", config);
        TestAuthenticationFilter.assertEquals((String)"A", (String)props.getProperty("a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitEmpty() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector().elements());
            filter.init(config);
            TestAuthenticationFilter.fail();
        }
        catch (ServletException ex) {
        }
        catch (Exception ex) {
            TestAuthenticationFilter.fail();
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInit() throws Exception {
        FilterConfig config;
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)"1000");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            filter.init(config);
            TestAuthenticationFilter.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            TestAuthenticationFilter.assertTrue((boolean)filter.isRandomSecret());
            TestAuthenticationFilter.assertNull((Object)filter.getCookieDomain());
            TestAuthenticationFilter.assertNull((Object)filter.getCookiePath());
            TestAuthenticationFilter.assertEquals((long)1000L, (long)filter.getValidity());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret")).elements());
            filter.init(config);
            TestAuthenticationFilter.assertFalse((boolean)filter.isRandomSecret());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "cookie.domain", "cookie.path")).elements());
            filter.init(config);
            TestAuthenticationFilter.assertEquals((String)".foo.com", (String)filter.getCookieDomain());
            TestAuthenticationFilter.assertEquals((String)"/bar", (String)filter.getCookiePath());
        }
        finally {
            filter.destroy();
        }
        DummyAuthenticationHandler.reset();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            TestAuthenticationFilter.assertTrue((boolean)DummyAuthenticationHandler.init);
        }
        finally {
            filter.destroy();
            TestAuthenticationFilter.assertTrue((boolean)DummyAuthenticationHandler.destroy);
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"kerberos");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            filter.init(config);
        }
        catch (ServletException servletException) {
        }
        finally {
            TestAuthenticationFilter.assertEquals(KerberosAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRequestURL() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"a=A&b=B");
            TestAuthenticationFilter.assertEquals((String)"http://foo:8080/bar?a=A&b=B", (String)filter.getRequestURL(request));
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetToken() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            AuthenticationToken newToken = filter.getToken(request);
            TestAuthenticationFilter.assertEquals((String)token.toString(), (String)newToken.toString());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTokenExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() - 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            try {
                filter.getToken(request);
                TestAuthenticationFilter.fail();
            }
            catch (AuthenticationException ex) {
            }
            catch (Exception ex) {
                TestAuthenticationFilter.fail();
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTokenInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            try {
                filter.getToken(request);
                TestAuthenticationFilter.fail();
            }
            catch (AuthenticationException ex) {
            }
            catch (Exception ex) {
                TestAuthenticationFilter.fail();
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoFilterNotAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDoFilterAuthentication(boolean withDomainPath, boolean invalidToken, boolean expired) throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("expired.token")).thenReturn((Object)Boolean.toString(expired));
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)"1000");
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "management.operation.return", "expired.token")).elements());
            if (withDomainPath) {
                Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
                Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
                Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "cookie.domain", "cookie.path", "management.operation.return")).elements());
            }
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getParameter("authenticated")).thenReturn((Object)"true");
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"authenticated=true");
            if (invalidToken) {
                Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie("hadoop.auth", "foo")});
            }
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            boolean[] calledDoFilter = new boolean[1];
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            if (expired) {
                ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addCookie((Cookie)Mockito.any(Cookie.class));
            } else {
                TestAuthenticationFilter.assertNotNull((Object)setCookie[0]);
                TestAuthenticationFilter.assertEquals((String)"hadoop.auth", (String)setCookie[0].getName());
                TestAuthenticationFilter.assertTrue((boolean)setCookie[0].getValue().contains("u="));
                TestAuthenticationFilter.assertTrue((boolean)setCookie[0].getValue().contains("p="));
                TestAuthenticationFilter.assertTrue((boolean)setCookie[0].getValue().contains("t="));
                TestAuthenticationFilter.assertTrue((boolean)setCookie[0].getValue().contains("e="));
                TestAuthenticationFilter.assertTrue((boolean)setCookie[0].getValue().contains("s="));
                TestAuthenticationFilter.assertTrue((boolean)calledDoFilter[0]);
                Signer signer = new Signer("secret".getBytes());
                String value = signer.verifyAndExtract(setCookie[0].getValue());
                AuthenticationToken token = AuthenticationToken.parse((String)value);
                TestAuthenticationFilter.assertEquals((float)(System.currentTimeMillis() + 1000000L), (float)token.getExpires(), (float)100.0f);
                if (withDomainPath) {
                    TestAuthenticationFilter.assertEquals((String)".foo.com", (String)setCookie[0].getDomain());
                    TestAuthenticationFilter.assertEquals((String)"/bar", (String)setCookie[0].getPath());
                } else {
                    TestAuthenticationFilter.assertNull((Object)setCookie[0].getDomain());
                    TestAuthenticationFilter.assertNull((Object)setCookie[0].getPath());
                }
            }
        }
        finally {
            filter.destroy();
        }
    }

    public void testDoFilterAuthentication() throws Exception {
        this._testDoFilterAuthentication(false, false, false);
    }

    public void testDoFilterAuthenticationImmediateExpiration() throws Exception {
        this._testDoFilterAuthentication(false, false, true);
    }

    public void testDoFilterAuthenticationWithInvalidToken() throws Exception {
        this._testDoFilterAuthentication(false, true, false);
    }

    public void testDoFilterAuthenticationWithDomainPath() throws Exception {
        this._testDoFilterAuthentication(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoFilterAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoFilterAuthenticatedExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
            TestAuthenticationFilter.assertNotNull((Object)setCookie[0]);
            TestAuthenticationFilter.assertEquals((String)"hadoop.auth", (String)setCookie[0].getName());
            TestAuthenticationFilter.assertEquals((String)"", (String)setCookie[0].getValue());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoFilterAuthenticatedInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Cookie[] setCookie = new Cookie[1];
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addCookie((Cookie)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
            TestAuthenticationFilter.assertNotNull((Object)setCookie[0]);
            TestAuthenticationFilter.assertEquals((String)"hadoop.auth", (String)setCookie[0].getName());
            TestAuthenticationFilter.assertEquals((String)"", (String)setCookie[0].getValue());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagementOperation() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"false");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
            Mockito.reset((Object[])new HttpServletRequest[]{request});
            Mockito.reset((Object[])new HttpServletResponse[]{response});
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer("secret".getBytes());
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
        }
        finally {
            filter.destroy();
        }
    }
}

