/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultiMechsAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger LOG = Logger.getLogger(MultiMechsAuthenticationHandler.class);
    private static final String MTYPE = "multiauth";
    private List<MultiMechsAuthenticationHandler> children = new ArrayList();

    public void init(Properties config) throws ServletException {
        String type;
        int i = 0;
        while ((type = config.getProperty("type" + i)) != null) {
            Class subClass = AuthHandlerEnum.getClassFromType((String)type);
            if (subClass != null) {
                try {
                    MultiMechsAuthenticationHandler child = (MultiMechsAuthenticationHandler)subClass.newInstance();
                    child.init(config);
                    this.children.add(child);
                }
                catch (InstantiationException ex) {
                    LOG.error((Object)("Unable to instantiate Authenticator Subclass of type: " + type + ". Will skip it"), (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)("Unable to init AuthenticationHandler Subclass of type: " + type + ". Will skip it"), (Throwable)ex);
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Unable to init AuthenticationHandler Subclass " + subClass.getName() + " that is used for authentication type " + type + ". Will skip it. " + "If no " + type + " configuration was intended no further action is needed" + " otherwise turn on DEBUG to see full exception trace"));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Full stacktrace", t);
                    }
                }
            } else {
                LOG.error((Object)("No implementation found for type: " + type + ". Corresponding class should be registered with AuthHandlerEnum"));
            }
            ++i;
        }
        if (this.children.isEmpty()) {
            if (i == 0) {
                for (AuthHandlerEnum value : AuthHandlerEnum.getOrderedArray()) {
                    config.setProperty("type" + value.getOrder(), value.getType());
                }
                this.init(config);
            } else {
                throw new ServletException("Can not proceeds with initializing Authenticators, since no concrete implementations for AuthenticationHandler are found");
            }
        }
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null) {
            for (MultiMechsAuthenticationHandler child : this.children) {
                MultiMechsAuthenticationHandler result = child.getAuthBasedEntity(authorization);
                if (result == null) continue;
                return result.postauthenticate(request, response);
            }
            LOG.error((Object)("Unknown Authorization: " + authorization + " please check your config files settings"));
            throw new AuthenticationException("Unknown Authorization: " + authorization + " please check your config files settings");
        }
        for (MultiMechsAuthenticationHandler child : this.children) {
            child.addHeader(response);
        }
        response.setStatus(401);
        return token;
    }

    protected void addHeader(HttpServletResponse response) {
        throw new UnsupportedOperationException("Each child of this class has to implement 'addHeader' method");
    }

    protected AuthenticationToken postauthenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        throw new UnsupportedOperationException("Each child of this class has to implement 'postauthenticate' method");
    }

    public void destroy() {
        for (MultiMechsAuthenticationHandler child : this.children) {
            child.destroy();
        }
    }

    protected MultiMechsAuthenticationHandler getAuthBasedEntity(String authorization) {
        throw new UnsupportedOperationException("Each child of this class has to implement 'getAuthBasedEntity' method");
    }

    public String getType() {
        return "multiauth";
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        throw new UnsupportedOperationException("Introduced in Hadoop2. Need to find out what to implement here first!");
    }
}

