/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class HadoopArchives
implements Tool {
    public static final int VERSION = 3;
    private static final Log LOG = LogFactory.getLog(HadoopArchives.class);
    private static final String NAME = "har";
    static final String SRC_LIST_LABEL = "har.src.list";
    static final String DST_DIR_LABEL = "har.dest.path";
    static final String TMP_DIR_LABEL = "har.tmp.dir";
    static final String JOB_DIR_LABEL = "har.job.dir";
    static final String SRC_COUNT_LABEL = "har.src.count";
    static final String TOTAL_SIZE_LABEL = "har.total.size";
    static final String DST_HAR_LABEL = "har.archive.name";
    static final String SRC_PARENT_LABEL = "har.parent.path";
    static final String HAR_BLOCKSIZE_LABEL = "har.block.size";
    static final String HAR_PARTSIZE_LABEL = "har.partfile.size";
    long partSize = 0x80000000L;
    long blockSize = 0x20000000L;
    private static final String usage = "archive -archiveName NAME -p <parent path> <src>* <dest>\n";
    private JobConf conf;
    static final String TEST_HADOOP_ARCHIVES_JAR_PATH = "test.hadoop.archives.jar";

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf, HadoopArchives.class);
        String testJar = System.getProperty("test.hadoop.archives.jar", null);
        if (testJar != null) {
            this.conf.setJar(testJar);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public HadoopArchives(Configuration conf) {
        this.setConf(conf);
    }

    private static void checkPaths(Configuration conf, List<Path> paths) throws IOException {
        for (Path p : paths) {
            FileSystem fs = p.getFileSystem(conf);
            if (fs.exists(p)) continue;
            throw new FileNotFoundException("Source " + p + " does not exist.");
        }
    }

    private void recursivels(FileSystem fs, FileStatusDir fdir, List<FileStatusDir> out) throws IOException {
        if (fdir.getFileStatus().isFile()) {
            out.add(fdir);
            return;
        }
        out.add(fdir);
        FileStatus[] listStatus = fs.listStatus(fdir.getFileStatus().getPath());
        fdir.setChildren(listStatus);
        for (FileStatus stat : listStatus) {
            FileStatusDir fstatDir = new FileStatusDir(stat, null);
            this.recursivels(fs, fstatDir, out);
        }
    }

    private boolean checkValidName(String name) {
        Path tmp = new Path(name);
        if (tmp.depth() != 1) {
            return false;
        }
        return name.endsWith(".har");
    }

    private Path largestDepth(List<Path> paths) {
        Path deepest = paths.get(0);
        for (Path p : paths) {
            if (p.depth() <= deepest.depth()) continue;
            deepest = p;
        }
        return deepest;
    }

    private Path relPathToRoot(Path fullPath, Path root) {
        Path justRoot = new Path("/");
        if (fullPath.depth() == root.depth()) {
            return justRoot;
        }
        if (fullPath.depth() > root.depth()) {
            Path retPath = new Path(fullPath.getName());
            Path parent = fullPath.getParent();
            for (int i = 0; i < fullPath.depth() - root.depth() - 1; ++i) {
                retPath = new Path(parent.getName(), retPath);
                parent = parent.getParent();
            }
            return new Path(justRoot, retPath);
        }
        return null;
    }

    private void writeTopLevelDirs(SequenceFile.Writer srcWriter, List<Path> paths, Path parentPath) throws IOException {
        ArrayList<Path> justDirs = new ArrayList<Path>();
        for (Path p : paths) {
            if (!p.getFileSystem(this.getConf()).isFile(p)) {
                justDirs.add(new Path(p.toUri().getPath()));
                continue;
            }
            justDirs.add(new Path(p.getParent().toUri().getPath()));
        }
        TreeMap<String, HashSet> allpaths = new TreeMap<String, HashSet>();
        Path deepest = this.largestDepth(paths);
        Path root = new Path("/");
        for (int i = parentPath.depth(); i < deepest.depth(); ++i) {
            ArrayList<Path> parents = new ArrayList<Path>();
            for (Path p : justDirs) {
                HashSet children;
                Path parent;
                if (p.compareTo((Object)root) == 0 || null == (parent = p.getParent())) continue;
                if (allpaths.containsKey(parent.toString())) {
                    children = (HashSet)allpaths.get(parent.toString());
                    children.add(p.getName());
                } else {
                    children = new HashSet();
                    children.add(p.getName());
                    allpaths.put(parent.toString(), children);
                }
                parents.add(parent);
            }
            justDirs = parents;
        }
        Set keyVals = allpaths.entrySet();
        for (Map.Entry entry : keyVals) {
            Path relPath = this.relPathToRoot(new Path((String)entry.getKey()), parentPath);
            if (relPath == null) continue;
            String[] children = new String[((HashSet)entry.getValue()).size()];
            int i = 0;
            for (String child : (HashSet)entry.getValue()) {
                children[i++] = child;
            }
            this.append(srcWriter, 0L, relPath.toString(), children);
        }
    }

    private void append(SequenceFile.Writer srcWriter, long len, String path, String[] children) throws IOException {
        srcWriter.append((Writable)new LongWritable(len), (Writable)new HarEntry(path, children));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void archive(Path parentPath, List<Path> srcPaths, String archiveName, Path dest) throws IOException {
        Path stagingArea;
        HadoopArchives.checkPaths((Configuration)this.conf, srcPaths);
        int numFiles = 0;
        long totalSize = 0L;
        FileSystem fs = parentPath.getFileSystem((Configuration)this.conf);
        this.blockSize = this.conf.getLong("har.block.size", this.blockSize);
        this.partSize = this.conf.getLong("har.partfile.size", this.partSize);
        this.conf.setLong("har.block.size", this.blockSize);
        this.conf.setLong("har.partfile.size", this.partSize);
        this.conf.set("har.archive.name", archiveName);
        this.conf.set("har.parent.path", parentPath.makeQualified(fs).toString());
        Path outputPath = new Path(dest, archiveName);
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outputPath);
        FileSystem outFs = outputPath.getFileSystem((Configuration)this.conf);
        if (outFs.exists(outputPath) || outFs.isFile(dest)) {
            throw new IOException("Invalid Output: " + outputPath);
        }
        this.conf.set("har.dest.path", outputPath.toString());
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((Cluster)new Cluster((Configuration)this.conf), (Configuration)this.conf);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        Path jobDirectory = new Path(stagingArea, "har_" + Integer.toString(new Random().nextInt(Integer.MAX_VALUE), 36));
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jobDirectory.getFileSystem((Configuration)this.conf), (Path)jobDirectory, (FsPermission)mapredSysPerms);
        this.conf.set("har.job.dir", jobDirectory.toString());
        FileSystem jobfs = jobDirectory.getFileSystem((Configuration)this.conf);
        Path srcFiles = new Path(jobDirectory, "_har_src_files");
        this.conf.set("har.src.list", srcFiles.toString());
        SequenceFile.Writer srcWriter = SequenceFile.createWriter((FileSystem)jobfs, (Configuration)this.conf, (Path)srcFiles, LongWritable.class, HarEntry.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            this.writeTopLevelDirs(srcWriter, srcPaths, parentPath);
            srcWriter.sync();
            for (Path src : srcPaths) {
                ArrayList allFiles = new ArrayList();
                FileStatus fstatus = fs.getFileStatus(src);
                FileStatusDir fdir = new FileStatusDir(fstatus, null);
                this.recursivels(fs, fdir, allFiles);
                for (FileStatusDir statDir : allFiles) {
                    String[] children;
                    FileStatus stat = statDir.getFileStatus();
                    long len = stat.isDirectory() ? 0L : stat.getLen();
                    Path path = this.relPathToRoot(stat.getPath(), parentPath);
                    if (stat.isDirectory()) {
                        FileStatus[] list = statDir.getChildren();
                        children = new String[list.length];
                        for (int i = 0; i < list.length; ++i) {
                            children[i] = list[i].getPath().getName();
                        }
                    } else {
                        children = null;
                    }
                    this.append(srcWriter, len, path.toString(), children);
                    srcWriter.sync();
                    ++numFiles;
                    totalSize += len;
                }
            }
        }
        finally {
            srcWriter.close();
        }
        jobfs.setReplication(srcFiles, (short)10);
        this.conf.setInt("har.src.count", numFiles);
        this.conf.setLong("har.total.size", totalSize);
        int numMaps = (int)(totalSize / this.partSize);
        this.conf.setNumMapTasks(numMaps == 0 ? 1 : numMaps);
        this.conf.setNumReduceTasks(1);
        this.conf.setInputFormat(HArchiveInputFormat.class);
        this.conf.setOutputFormat(NullOutputFormat.class);
        this.conf.setMapperClass(HArchivesMapper.class);
        this.conf.setReducerClass(HArchivesReducer.class);
        this.conf.setMapOutputKeyClass(IntWritable.class);
        this.conf.setMapOutputValueClass(Text.class);
        FileInputFormat.addInputPath((JobConf)this.conf, (Path)jobDirectory);
        this.conf.setSpeculativeExecution(false);
        JobClient.runJob((JobConf)this.conf);
        try {
            jobfs.delete(jobDirectory, true);
        }
        catch (IOException ie) {
            LOG.info((Object)("Unable to clean tmp directory " + jobDirectory));
        }
    }

    public int run(String[] args) throws Exception {
        try {
            Path parentPath = null;
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            Path destPath = null;
            String archiveName = null;
            if (args.length < 5) {
                System.out.println("archive -archiveName NAME -p <parent path> <src>* <dest>\n");
                throw new IOException("Invalid usage.");
            }
            if (!"-archiveName".equals(args[0])) {
                System.out.println("archive -archiveName NAME -p <parent path> <src>* <dest>\n");
                throw new IOException("Archive Name not specified.");
            }
            archiveName = args[1];
            if (!this.checkValidName(archiveName)) {
                System.out.println("archive -archiveName NAME -p <parent path> <src>* <dest>\n");
                throw new IOException("Invalid name for archives. " + archiveName);
            }
            int i = 2;
            if (!"-p".equals(args[i])) {
                System.out.println("archive -archiveName NAME -p <parent path> <src>* <dest>\n");
                throw new IOException("Parent path not specified.");
            }
            parentPath = new Path(args[i + 1]);
            if (!parentPath.isAbsolute()) {
                parentPath = parentPath.getFileSystem(this.getConf()).makeQualified(parentPath);
            }
            i += 2;
            while (i < args.length) {
                if (i == args.length - 1) {
                    destPath = new Path(args[i]);
                    if (!destPath.isAbsolute()) {
                        destPath = destPath.getFileSystem(this.getConf()).makeQualified(destPath);
                    }
                } else {
                    Path argPath = new Path(args[i]);
                    if (argPath.isAbsolute()) {
                        System.out.println("archive -archiveName NAME -p <parent path> <src>* <dest>\n");
                        throw new IOException("source path " + argPath + " is not relative  to " + parentPath);
                    }
                    srcPaths.add(new Path(parentPath, argPath));
                }
                ++i;
            }
            if (srcPaths.size() == 0) {
                srcPaths.add(parentPath);
            }
            ArrayList<Path> globPaths = new ArrayList<Path>();
            for (Path p : srcPaths) {
                FileSystem fs = p.getFileSystem(this.getConf());
                FileStatus[] statuses = fs.globStatus(p);
                if (statuses == null) continue;
                for (FileStatus status : statuses) {
                    globPaths.add(fs.makeQualified(status.getPath()));
                }
            }
            if (globPaths.isEmpty()) {
                throw new IOException("The resolved paths set is empty.  Please check whether the srcPaths exist, where srcPaths = " + srcPaths);
            }
            this.archive(parentPath, globPaths, archiveName, destPath);
        }
        catch (IOException ie) {
            System.err.println(ie.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        JobConf job = new JobConf(HadoopArchives.class);
        HadoopArchives harchives = new HadoopArchives((Configuration)job);
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)harchives, (String[])args);
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception in archives  ", (Throwable)e);
            System.err.println(e.getClass().getSimpleName() + " in archives");
            String s = e.getLocalizedMessage();
            if (s != null) {
                System.err.println(s);
            } else {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        System.exit(ret);
    }
}

