/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHadoopArchives {
    public static final String HADOOP_ARCHIVES_JAR = JarFinder.getJar(HadoopArchives.class);
    private static final String inputDir = "input";
    private Path inputPath;
    private MiniDFSCluster dfscluster;
    private Configuration conf;
    private FileSystem fs;
    private Path archivePath;

    public TestHadoopArchives() {
        ((Log4JLogger)LogFactory.getLog(Groups.class)).getLogger().setLevel(Level.ERROR);
    }

    private static Path createFile(Path dir, String filename, FileSystem fs) throws IOException {
        Path f = new Path(dir, filename);
        FSDataOutputStream out = fs.create(f);
        out.write(filename.getBytes());
        out.close();
        return f;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("yarn.scheduler.capacity.root.queues", "default");
        this.conf.set("yarn.scheduler.capacity.root.default.capacity", "100");
        this.dfscluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).format(true).build();
        this.fs = this.dfscluster.getFileSystem();
        this.inputPath = new Path(this.fs.getHomeDirectory(), "input");
        this.archivePath = new Path(this.fs.getHomeDirectory(), "archive");
        this.fs.mkdirs(this.inputPath);
        TestHadoopArchives.createFile((Path)this.inputPath, (String)"a", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)this.inputPath, (String)"b", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)this.inputPath, (String)"c", (FileSystem)this.fs);
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.dfscluster != null) {
                this.dfscluster.shutdown();
            }
            if (this.dfscluster != null) {
                this.dfscluster.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @Test
    public void testRelativePath() throws Exception {
        this.fs.delete(this.archivePath, true);
        Path sub1 = new Path(this.inputPath, "dir1");
        this.fs.mkdirs(sub1);
        TestHadoopArchives.createFile((Path)sub1, (String)"a", (FileSystem)this.fs);
        FsShell shell = new FsShell(this.conf);
        List originalPaths = TestHadoopArchives.lsr((FsShell)shell, (String)"input");
        System.out.println("originalPath: " + originalPaths);
        URI uri = this.fs.getUri();
        String prefix = "har://hdfs-" + uri.getHost() + ":" + uri.getPort() + this.archivePath.toUri().getPath() + "/";
        String harName = "foo.har";
        String[] args = new String[]{"-archiveName", "foo.har", "-p", "input", "*", "archive"};
        System.setProperty("test.hadoop.archives.jar", HADOOP_ARCHIVES_JAR);
        HadoopArchives har = new HadoopArchives(this.conf);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)har, (String[])args));
        List harPaths = TestHadoopArchives.lsr((FsShell)shell, (String)(prefix + "foo.har"));
        Assert.assertEquals((Object)originalPaths, (Object)harPaths);
    }

    @Test
    public void testPathWithSpaces() throws Exception {
        this.fs.delete(this.archivePath, true);
        TestHadoopArchives.createFile((Path)this.inputPath, (String)"c c", (FileSystem)this.fs);
        Path sub1 = new Path(this.inputPath, "sub 1");
        this.fs.mkdirs(sub1);
        TestHadoopArchives.createFile((Path)sub1, (String)"file x y z", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)sub1, (String)"file", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)sub1, (String)"x", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)sub1, (String)"y", (FileSystem)this.fs);
        TestHadoopArchives.createFile((Path)sub1, (String)"z", (FileSystem)this.fs);
        Path sub2 = new Path(this.inputPath, "sub 1 with suffix");
        this.fs.mkdirs(sub2);
        TestHadoopArchives.createFile((Path)sub2, (String)"z", (FileSystem)this.fs);
        FsShell shell = new FsShell(this.conf);
        String inputPathStr = this.inputPath.toUri().getPath();
        List originalPaths = TestHadoopArchives.lsr((FsShell)shell, (String)inputPathStr);
        URI uri = this.fs.getUri();
        String prefix = "har://hdfs-" + uri.getHost() + ":" + uri.getPort() + this.archivePath.toUri().getPath() + "/";
        String harName = "foo.har";
        String[] args = new String[]{"-archiveName", "foo.har", "-p", inputPathStr, "*", this.archivePath.toString()};
        System.setProperty("test.hadoop.archives.jar", HADOOP_ARCHIVES_JAR);
        HadoopArchives har = new HadoopArchives(this.conf);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)har, (String[])args));
        List harPaths = TestHadoopArchives.lsr((FsShell)shell, (String)(prefix + "foo.har"));
        Assert.assertEquals((Object)originalPaths, (Object)harPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> lsr(FsShell shell, String dir) throws Exception {
        String results;
        System.out.println("lsr root=" + dir);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-lsr", dir}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("lsr results:\n" + results);
        String dirname = dir;
        if (dir.lastIndexOf("/") != -1) {
            dirname = dir.substring(dir.lastIndexOf("/"));
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(results, "\n");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            int i = s.indexOf(dirname);
            if (i < 0) continue;
            paths.add(s.substring(i + dirname.length()));
        }
        Collections.sort(paths);
        System.out.println("lsr paths = " + ((Object)paths).toString().replace(", ", ",\n  "));
        return paths;
    }
}

