/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.streaming.Environment;

public class StreamUtil {
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    static final long TB = 0x10000000000L;
    static final long PB = 0x4000000000000L;
    static DecimalFormat dfm = new DecimalFormat("####.000");
    static DecimalFormat ifm = new DecimalFormat("###,###,###,###,###");
    static Environment env;
    static String HOST;
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    static char[] space;
    private static Environment env_;

    public static Class goodClassOrNull(Configuration conf, String className, String defaultPackage) {
        if (className.indexOf(46) == -1 && defaultPackage != null) {
            className = defaultPackage + "." + className;
        }
        Class clazz = null;
        try {
            clazz = conf.getClassByName(className);
        }
        catch (ClassNotFoundException cnf) {
            // empty catch block
        }
        return clazz;
    }

    public static String findInClasspath(String className) {
        return StreamUtil.findInClasspath(className, StreamUtil.class.getClassLoader());
    }

    public static String findInClasspath(String className, ClassLoader loader) {
        String codePath;
        String relPath = className;
        relPath = relPath.replace('.', '/');
        URL classUrl = loader.getResource(relPath = relPath + ".class");
        if (classUrl != null) {
            boolean inJar = classUrl.getProtocol().equals("jar");
            codePath = classUrl.toString();
            if (codePath.startsWith("jar:")) {
                codePath = codePath.substring("jar:".length());
            }
            if (codePath.startsWith("file:")) {
                codePath = codePath.substring("file:".length());
            }
            if (inJar) {
                int bang = codePath.lastIndexOf(33);
                codePath = codePath.substring(0, bang);
            } else {
                int pos = codePath.lastIndexOf(relPath);
                if (pos == -1) {
                    throw new IllegalArgumentException("invalid codePath: className=" + className + " codePath=" + codePath);
                }
                codePath = codePath.substring(0, pos);
            }
        } else {
            codePath = null;
        }
        return codePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unJar(File jarFile, File toDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = jar.getInputStream(entry);
                try {
                    File file = new File(toDir, entry.getName());
                    file.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            jar.close();
        }
    }

    public static String dfmt(double d) {
        return dfm.format(d);
    }

    public static String ifmt(double d) {
        return ifm.format(d);
    }

    public static String formatBytes(long numBytes) {
        StringBuffer buf = new StringBuffer();
        boolean bDetails = true;
        double num = numBytes;
        if (numBytes < 1024L) {
            buf.append(numBytes).append(" B");
            bDetails = false;
        } else if (numBytes < 0x100000L) {
            buf.append(StreamUtil.dfmt(num / 1024.0)).append(" KB");
        } else if (numBytes < 0x40000000L) {
            buf.append(StreamUtil.dfmt(num / 1048576.0)).append(" MB");
        } else if (numBytes < 0x10000000000L) {
            buf.append(StreamUtil.dfmt(num / 1.073741824E9)).append(" GB");
        } else if (numBytes < 0x4000000000000L) {
            buf.append(StreamUtil.dfmt(num / 1.099511627776E12)).append(" TB");
        } else {
            buf.append(StreamUtil.dfmt(num / 1.125899906842624E15)).append(" PB");
        }
        if (bDetails) {
            buf.append(" (").append(StreamUtil.ifmt(numBytes)).append(" bytes)");
        }
        return buf.toString();
    }

    public static String formatBytes2(long numBytes) {
        StringBuffer buf = new StringBuffer();
        long u = 0L;
        if (numBytes >= 0x10000000000L) {
            u = numBytes / 0x10000000000L;
            numBytes -= u * 0x10000000000L;
            buf.append(u).append(" TB ");
        }
        if (numBytes >= 0x40000000L) {
            u = numBytes / 0x40000000L;
            numBytes -= u * 0x40000000L;
            buf.append(u).append(" GB ");
        }
        if (numBytes >= 0x100000L) {
            u = numBytes / 0x100000L;
            numBytes -= u * 0x100000L;
            buf.append(u).append(" MB ");
        }
        if (numBytes >= 1024L) {
            u = numBytes / 1024L;
            numBytes -= u * 1024L;
            buf.append(u).append(" KB ");
        }
        buf.append(u).append(" B");
        return buf.toString();
    }

    static void exec(String arg, PrintStream log) {
        StreamUtil.exec(new String[]{arg}, log);
    }

    static void exec(String[] args, PrintStream log) {
        try {
            log.println("Exec: start: " + Arrays.asList(args));
            Process proc = Runtime.getRuntime().exec(args);
            new StreamConsumer(proc.getErrorStream(), log).start();
            new StreamConsumer(proc.getInputStream(), log).start();
            int status = proc.waitFor();
            log.println("Exec: status=" + status + ": " + Arrays.asList(args));
        }
        catch (InterruptedException in) {
            in.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    static String qualifyHost(String url) {
        try {
            return StreamUtil.qualifyHost(new URL(url)).toString();
        }
        catch (IOException io) {
            return url;
        }
    }

    static URL qualifyHost(URL url) {
        try {
            InetAddress a = InetAddress.getByName(url.getHost());
            String qualHost = a.getCanonicalHostName();
            URL q = new URL(url.getProtocol(), qualHost, url.getPort(), url.getFile());
            return q;
        }
        catch (IOException io) {
            return url;
        }
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if (regexpSpecials.indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    public static String safeGetCanonicalPath(File f) {
        try {
            String s = f.getCanonicalPath();
            return s == null ? f.toString() : s;
        }
        catch (IOException io) {
            return f.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        FileInputStream in = new FileInputStream(f);
        String contents = null;
        try {
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String slurpHadoop(Path p, FileSystem fs) throws IOException {
        int len = (int)fs.getLength(p);
        byte[] buf = new byte[len];
        FSDataInputStream in = fs.open(p);
        String contents = null;
        try {
            in.readFully(in.getPos(), buf);
            contents = new String(buf, "UTF-8");
        }
        finally {
            in.close();
        }
        return contents;
    }

    public static String rjustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = StreamUtil.getSpace(width - s.length()) + s;
        }
        return s;
    }

    public static String ljustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = s + StreamUtil.getSpace(width - s.length());
        }
        return s;
    }

    public static String getSpace(int len) {
        if (len > space.length) {
            space = new char[Math.max(len, 2 * space.length)];
            Arrays.fill(space, ' ');
        }
        return new String(space, 0, len);
    }

    static Environment env() {
        if (env_ != null) {
            return env_;
        }
        try {
            env_ = new Environment();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return env_;
    }

    public static String makeJavaCommand(Class main, String[] argv) {
        ArrayList<String> vargs = new ArrayList<String>();
        File javaHomeBin = new File(System.getProperty("java.home"), "bin");
        File jvm = new File(javaHomeBin, "java");
        vargs.add(jvm.toString());
        vargs.add("-classpath");
        vargs.add("\"" + System.getProperty("java.class.path") + "\"");
        vargs.add("-Xmx" + Runtime.getRuntime().maxMemory());
        vargs.add(main.getName());
        for (int i = 0; i < argv.length; ++i) {
            vargs.add(argv[i]);
        }
        return StreamUtil.collate(vargs, " ");
    }

    public static String collate(Object[] args, String sep) {
        return StreamUtil.collate(Arrays.asList(args), sep);
    }

    public static String collate(List args, String sep) {
        StringBuffer buf = new StringBuffer();
        Iterator it = args.iterator();
        while (it.hasNext()) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(it.next());
        }
        return buf.toString();
    }

    public static FileSplit getCurrentSplit(JobConf job) {
        String path = job.get("map.input.file");
        if (path == null) {
            return null;
        }
        Path p = new Path(path);
        long start = Long.parseLong(job.get("map.input.start"));
        long length = Long.parseLong(job.get("map.input.length"));
        return new FileSplit(p, start, length, job);
    }

    public static boolean isLocalJobTracker(JobConf job) {
        return job.get("mapred.job.tracker", "maprdummy").equals("local");
    }

    public static TaskId getTaskInfo(JobConf job) {
        TaskId res = new TaskId();
        String id = job.get("mapred.task.id");
        if (StreamUtil.isLocalJobTracker(job)) {
            res.mapTask = job.getBoolean("mapred.task.is.map", true);
            res.jobid = "0";
            res.taskid = 0;
            res.execid = 0;
        } else {
            String[] e = id.split("_");
            res.mapTask = e[3].equals("m");
            res.jobid = e[1] + "_" + e[2];
            res.taskid = Integer.parseInt(e[4]);
            res.execid = Integer.parseInt(e[5]);
        }
        return res;
    }

    public static void touch(File file) throws IOException {
        file = file.getAbsoluteFile();
        FileOutputStream out = new FileOutputStream(file);
        out.close();
        if (!file.exists()) {
            throw new IOException("touch failed: " + file);
        }
    }

    public static boolean isCygwin() {
        String OS = System.getProperty("os.name");
        return OS.indexOf("Windows") > -1;
    }

    public static String localizeBin(String path) {
        if (StreamUtil.isCygwin()) {
            path = "C:/cygwin/" + path;
        }
        return path;
    }

    public static String getBoundAntProperty(String name, String defaultVal) {
        String val = System.getProperty(name);
        if (val != null && val.indexOf("${") >= 0) {
            val = null;
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    static {
        try {
            env = new Environment();
            HOST = env.getHost();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        space = new char[300];
        Arrays.fill(space, ' ');
    }

    static class TaskId {
        boolean mapTask;
        String jobid;
        int taskid;
        int execid;

        TaskId() {
        }
    }

    static class StreamConsumer
    extends Thread {
        LineNumberReader bin;
        DataOutputStream bout;

        StreamConsumer(InputStream in, OutputStream out) {
            this.bin = new LineNumberReader(new BufferedReader(new InputStreamReader(in)));
            if (out != null) {
                this.bout = new DataOutputStream(out);
            }
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.bin.readLine()) != null) {
                    if (this.bout == null) continue;
                    this.bout.writeUTF(line);
                    this.bout.writeChar(10);
                }
                this.bout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

