/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.logging;

import hidden.bkjournal.org.jboss.netty.logging.AbstractInternalLogger;
import hidden.bkjournal.org.jboss.netty.logging.InternalLogger;
import hidden.bkjournal.org.jboss.netty.logging.OsgiLoggerFactory;
import org.osgi.service.log.LogService;

class OsgiLogger
extends AbstractInternalLogger {
    private final OsgiLoggerFactory parent;
    private final InternalLogger fallback;
    private final String name;
    private final String prefix;

    OsgiLogger(OsgiLoggerFactory parent, String name, InternalLogger fallback) {
        this.parent = parent;
        this.name = name;
        this.fallback = fallback;
        this.prefix = "[" + name + "] ";
    }

    public void debug(String msg) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(4, this.prefix + msg);
        } else {
            this.fallback.debug(msg);
        }
    }

    public void debug(String msg, Throwable cause) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(4, this.prefix + msg, cause);
        } else {
            this.fallback.debug(msg, cause);
        }
    }

    public void error(String msg) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(1, this.prefix + msg);
        } else {
            this.fallback.error(msg);
        }
    }

    public void error(String msg, Throwable cause) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(1, this.prefix + msg, cause);
        } else {
            this.fallback.error(msg, cause);
        }
    }

    public void info(String msg) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(3, this.prefix + msg);
        } else {
            this.fallback.info(msg);
        }
    }

    public void info(String msg, Throwable cause) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(3, this.prefix + msg, cause);
        } else {
            this.fallback.info(msg, cause);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(2, this.prefix + msg);
        } else {
            this.fallback.warn(msg);
        }
    }

    public void warn(String msg, Throwable cause) {
        LogService logService = this.parent.getLogService();
        if (logService != null) {
            logService.log(2, this.prefix + msg, cause);
        } else {
            this.fallback.warn(msg, cause);
        }
    }

    public String toString() {
        return this.name;
    }
}

