/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.bkjournal;

import com.google.common.base.Charsets;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.ZooDefs;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import hidden.bkjournal.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.contrib.bkjournal.BKJournalProtos;

class MaxTxId {
    static final Log LOG = LogFactory.getLog(MaxTxId.class);
    private final ZooKeeper zkc;
    private final String path;
    private Stat currentStat;

    MaxTxId(ZooKeeper zkc, String path) {
        this.zkc = zkc;
        this.path = path;
    }

    synchronized void store(long maxTxId) throws IOException {
        long currentMax = this.get();
        if (currentMax < maxTxId) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Setting maxTxId to " + maxTxId));
            }
            this.reset(maxTxId);
        }
    }

    synchronized void reset(long maxTxId) throws IOException {
        try {
            BKJournalProtos.MaxTxIdProto.Builder builder = BKJournalProtos.MaxTxIdProto.newBuilder().setTxId(maxTxId);
            byte[] data = TextFormat.printToString((MessageOrBuilder)builder.build()).getBytes(Charsets.UTF_8);
            if (this.currentStat != null) {
                this.currentStat = this.zkc.setData(this.path, data, this.currentStat.getVersion());
            } else {
                this.zkc.create(this.path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Error writing max tx id", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while writing max tx id", e);
        }
    }

    synchronized long get() throws IOException {
        try {
            this.currentStat = this.zkc.exists(this.path, false);
            if (this.currentStat == null) {
                return 0L;
            }
            byte[] bytes = this.zkc.getData(this.path, false, this.currentStat);
            BKJournalProtos.MaxTxIdProto.Builder builder = BKJournalProtos.MaxTxIdProto.newBuilder();
            TextFormat.merge((CharSequence)new String(bytes, Charsets.UTF_8), (Message.Builder)builder);
            if (!builder.isInitialized()) {
                throw new IOException("Invalid/Incomplete data in znode");
            }
            return builder.build().getTxId();
        }
        catch (KeeperException e) {
            throw new IOException("Error reading the max tx id from zk", e);
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while reading thr max tx id", ie);
        }
    }
}

