/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.handler.codec.rtsp;

import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffer;
import hidden.bkjournal.org.jboss.netty.channel.Channel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelHandlerContext;
import hidden.bkjournal.org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpMessage;
import hidden.bkjournal.org.jboss.netty.handler.codec.http.HttpMessageDecoder;

public abstract class RtspMessageDecoder
extends HttpMessageDecoder {
    private final DecoderEmbedder<HttpMessage> aggregator;

    protected RtspMessageDecoder() {
        this(4096, 8192, 8192);
    }

    protected RtspMessageDecoder(int maxInitialLineLength, int maxHeaderSize, int maxContentLength) {
        super(maxInitialLineLength, maxHeaderSize, maxContentLength * 2);
        this.aggregator = new DecoderEmbedder(new HttpChunkAggregator(maxContentLength));
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, HttpMessageDecoder.State state) throws Exception {
        Object o = super.decode(ctx, channel, buffer, state);
        if (o != null && this.aggregator.offer(o)) {
            return this.aggregator.poll();
        }
        return null;
    }

    protected boolean isContentAlwaysEmpty(HttpMessage msg) {
        boolean empty = super.isContentAlwaysEmpty(msg);
        if (empty) {
            return true;
        }
        if (!msg.containsHeader("Content-Length")) {
            return true;
        }
        return empty;
    }
}

