/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.oio;

import hidden.bkjournal.org.jboss.netty.channel.AbstractChannel;
import hidden.bkjournal.org.jboss.netty.channel.Channel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFuture;
import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ChannelSink;
import hidden.bkjournal.org.jboss.netty.channel.socket.DefaultSocketChannelConfig;
import hidden.bkjournal.org.jboss.netty.channel.socket.SocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.SocketChannelConfig;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

abstract class OioSocketChannel
extends AbstractChannel
implements SocketChannel {
    final Socket socket;
    final Object interestOpsLock = new Object();
    private final SocketChannelConfig config;
    volatile Thread workerThread;
    private volatile InetSocketAddress localAddress;
    private volatile InetSocketAddress remoteAddress;

    OioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        this.config = new DefaultSocketChannelConfig(socket);
    }

    public SocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = (InetSocketAddress)this.socket.getLocalSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    public boolean isBound() {
        return this.isOpen() && this.socket.isBound();
    }

    public boolean isConnected() {
        return this.isOpen() && this.socket.isConnected();
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected void setInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    abstract PushbackInputStream getInputStream();

    abstract OutputStream getOutputStream();

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }
}

