/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.oio;

import hidden.bkjournal.org.jboss.netty.channel.AbstractChannelSink;
import hidden.bkjournal.org.jboss.netty.channel.Channel;
import hidden.bkjournal.org.jboss.netty.channel.ChannelEvent;
import hidden.bkjournal.org.jboss.netty.channel.ChannelFuture;
import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ChannelState;
import hidden.bkjournal.org.jboss.netty.channel.ChannelStateEvent;
import hidden.bkjournal.org.jboss.netty.channel.Channels;
import hidden.bkjournal.org.jboss.netty.channel.MessageEvent;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioAcceptedSocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioServerSocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioSocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioWorker;
import hidden.bkjournal.org.jboss.netty.logging.InternalLogger;
import hidden.bkjournal.org.jboss.netty.logging.InternalLoggerFactory;
import hidden.bkjournal.org.jboss.netty.util.ThreadRenamingRunnable;
import hidden.bkjournal.org.jboss.netty.util.internal.DeadLockProofWorker;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;

class OioServerSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketPipelineSink.class);
    final Executor workerExecutor;

    OioServerSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof OioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof OioAcceptedSocketChannel) {
            this.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        OioServerSocketChannel channel = (OioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            OioAcceptedSocketChannel channel = (OioAcceptedSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    OioWorker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    OioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    OioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            OioSocketChannel channel = (OioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            Object message = event.getMessage();
            OioWorker.write(channel, future, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(OioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            channel.socket.bind(localAddress, channel.getConfig().getBacklog());
            bound = true;
            future.setSuccess();
            localAddress = channel.getLocalAddress();
            Channels.fireChannelBound(channel, localAddress);
            Executor bossExecutor = ((OioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
            DeadLockProofWorker.start(bossExecutor, new ThreadRenamingRunnable(new Boss(channel), "Old I/O server boss (" + channel + ')'));
            bossStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (!bossStarted && bound) {
                this.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(OioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future.setSuccess();
                }
            }
            finally {
                channel.shutdownLock.unlock();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class Boss
    implements Runnable {
        private final OioServerSocketChannel channel;

        Boss(OioServerSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.channel.shutdownLock.lock();
            try {
                while (this.channel.isBound()) {
                    try {
                        Socket acceptedSocket = this.channel.socket.accept();
                        try {
                            ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                            OioAcceptedSocketChannel acceptedChannel = new OioAcceptedSocketChannel(this.channel, this.channel.getFactory(), pipeline, OioServerSocketPipelineSink.this, acceptedSocket);
                            DeadLockProofWorker.start(OioServerSocketPipelineSink.this.workerExecutor, new ThreadRenamingRunnable(new OioWorker(acceptedChannel), "Old I/O server worker (parentId: " + this.channel.getId() + ", " + this.channel + ')'));
                        }
                        catch (Exception e) {
                            logger.warn("Failed to initialize an accepted socket.", e);
                            try {
                                acceptedSocket.close();
                            }
                            catch (IOException e2) {
                                logger.warn("Failed to close a partially accepted socket.", e2);
                            }
                        }
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (Throwable e) {
                        if (!this.channel.socket.isBound()) return;
                        if (this.channel.socket.isClosed()) {
                            return;
                        }
                        logger.warn("Failed to accept a connection.", e);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return;
            }
            finally {
                this.channel.shutdownLock.unlock();
            }
        }
    }
}

