/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.oio;

import hidden.bkjournal.org.jboss.netty.channel.ChannelPipeline;
import hidden.bkjournal.org.jboss.netty.channel.ChannelSink;
import hidden.bkjournal.org.jboss.netty.channel.socket.ServerSocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioServerSocketChannel;
import hidden.bkjournal.org.jboss.netty.channel.socket.oio.OioServerSocketPipelineSink;
import hidden.bkjournal.org.jboss.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class OioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;

    public OioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new OioServerSocketPipelineSink(workerExecutor);
    }

    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioServerSocketChannel(this, pipeline, this.sink);
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

