/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.jboss.netty.channel.socket.nio;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;

final class SocketReceiveBufferPool {
    private static final int POOL_SIZE = 8;
    private final SoftReference<ByteBuffer>[] pool = new SoftReference[8];

    SocketReceiveBufferPool() {
    }

    final ByteBuffer acquire(int size) {
        SoftReference<ByteBuffer>[] pool = this.pool;
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref == null) continue;
            ByteBuffer buf = ref.get();
            if (buf == null) {
                pool[i] = null;
                continue;
            }
            if (buf.capacity() < size) continue;
            pool[i] = null;
            buf.clear();
            return buf;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(SocketReceiveBufferPool.normalizeCapacity(size));
        buf.clear();
        return buf;
    }

    final void release(ByteBuffer buffer) {
        SoftReference<ByteBuffer>[] pool = this.pool;
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref != null && ref.get() != null) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
        int capacity = buffer.capacity();
        for (int i = 0; i < 8; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            ByteBuffer pooled = ref.get();
            if (pooled == null) {
                pool[i] = null;
                continue;
            }
            if (pooled.capacity() >= capacity) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
    }

    private static final int normalizeCapacity(int capacity) {
        int q = capacity >>> 10;
        int r = capacity & 0x3FF;
        if (r != 0) {
            ++q;
        }
        return q << 10;
    }
}

