/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.zookeeper.server;

import hidden.bkjournal.org.apache.zookeeper.Login;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslServer {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.serverconfig";
    public static final String DEFAULT_LOGIN_CONTEXT_NAME = "Server";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslServer.class);
    private SaslServer saslServer;

    ZooKeeperSaslServer(Login login) {
        this.saslServer = this.createSaslServer(login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslServer createSaslServer(final Login login) {
        Login login2 = login;
        synchronized (login2) {
            String mechOpt = System.getProperty("zookeeper.authMech");
            Subject subject = login.getSubject();
            if (subject != null) {
                if (subject.getPrincipals().size() > 0) {
                    try {
                        String serviceHostname;
                        String servicePrincipalName;
                        String mech;
                        Object[] principals = subject.getPrincipals().toArray();
                        Principal servicePrincipal = (Principal)principals[0];
                        String servicePrincipalNameAndHostname = servicePrincipal.getName();
                        String string = mech = mechOpt == null ? "GSSAPI" : mechOpt;
                        if (mech.equals("GSSAPI")) {
                            int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                            servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                            String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1, servicePrincipalNameAndHostname.length());
                            indexOf = serviceHostnameAndKerbDomain.indexOf("@");
                            serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOf);
                            LOG.debug("serviceHostname is '" + serviceHostname + "'");
                            LOG.debug("servicePrincipalName is " + servicePrincipalName + "'");
                        } else {
                            serviceHostname = "default";
                            servicePrincipalName = null;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SASL mechanism(mech) is " + mech + "'");
                            LOG.debug("SASL servicePrincipalNameAndHostname is " + servicePrincipalNameAndHostname);
                        }
                        try {
                            return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                                @Override
                                public SaslServer run() {
                                    try {
                                        SaslServer saslServer = Sasl.createSaslServer(mech, servicePrincipalName, serviceHostname, null, login.callbackHandler);
                                        return saslServer;
                                    }
                                    catch (SaslException e) {
                                        LOG.error("Zookeeper Server failed to create a SaslServer to interact with a client during session initiation: " + e);
                                        e.printStackTrace();
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            LOG.error("Zookeeper Quorum member experienced a PrivilegedActionException exception while creating a SaslServer using a JAAS principal context:" + e);
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("server principal name/hostname determination error: " + e);
                    }
                } else {
                    try {
                        SaslServer saslServer = Sasl.createSaslServer("DIGEST-MD5", "zookeeper", "zk-sasl-md5", null, login.callbackHandler);
                        return saslServer;
                    }
                    catch (SaslException e) {
                        LOG.error("Zookeeper Quorum member failed to create a SaslServer to interact with a client during session initiation: " + e);
                    }
                }
            }
        }
        LOG.error("failed to create saslServer object.");
        return null;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }

    static {
        String saslProviderClassName = System.getProperty("zookeeper.saslprovider");
        if (saslProviderClassName != null) {
            try {
                Class<?> clazz = Class.forName(saslProviderClassName);
                Security.addProvider((Provider)clazz.newInstance());
            }
            catch (ClassNotFoundException e) {
                LOG.warn("ClassNotFoundException: " + saslProviderClassName, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.warn("InstantiationException: " + saslProviderClassName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("IllegalAccessException: " + saslProviderClassName, (Throwable)e);
            }
        }
    }
}

