/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.zookeeper.client;

import hidden.bkjournal.org.apache.zookeeper.client.HostProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticHostProvider
implements HostProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProvider.class);
    private final List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private int lastIndex = -1;
    private int currentIndex = -1;

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses) throws UnknownHostException {
        for (InetSocketAddress address : serverAddresses) {
            InetAddress[] resolvedAddresses;
            for (InetAddress resolvedAddress : resolvedAddresses = InetAddress.getAllByName(address.getHostName())) {
                this.serverAddresses.add(new InetSocketAddress(resolvedAddress.getHostAddress(), address.getPort()));
            }
        }
        if (this.serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        Collections.shuffle(this.serverAddresses);
    }

    @Override
    public int size() {
        return this.serverAddresses.size();
    }

    @Override
    public InetSocketAddress next(long spinDelay) {
        ++this.currentIndex;
        if (this.currentIndex == this.serverAddresses.size()) {
            this.currentIndex = 0;
        }
        if (this.currentIndex == this.lastIndex && spinDelay > 0L) {
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Unexpected exception", (Throwable)e);
            }
        } else if (this.lastIndex == -1) {
            this.lastIndex = 0;
        }
        return this.serverAddresses.get(this.currentIndex);
    }

    @Override
    public void onConnected() {
        this.lastIndex = this.currentIndex;
    }
}

