/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.zookeeper;

import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.Op;
import hidden.bkjournal.org.apache.zookeeper.OpResult;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import hidden.bkjournal.org.apache.zookeeper.data.ACL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private ZooKeeper zk;
    private List<Op> ops = new ArrayList<Op>();

    protected Transaction(ZooKeeper zk) {
        this.zk = zk;
    }

    public Transaction create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        this.ops.add(Op.create(path, data, acl, createMode.toFlag()));
        return this;
    }

    public Transaction delete(String path, int version) {
        this.ops.add(Op.delete(path, version));
        return this;
    }

    public Transaction check(String path, int version) {
        this.ops.add(Op.check(path, version));
        return this;
    }

    public Transaction setData(String path, byte[] data, int version) {
        this.ops.add(Op.setData(path, data, version));
        return this;
    }

    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.zk.multi(this.ops);
    }
}

