/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.util;

import hidden.bkjournal.org.apache.zookeeper.AsyncCallback;
import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import hidden.bkjournal.org.apache.zookeeper.data.ACL;
import java.io.File;
import java.util.List;

public class ZkUtils {
    public static void createFullPathOptimistic(final ZooKeeper zk, final String originalPath, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback callback, Object ctx) {
        zk.create(originalPath, data, acl, createMode, new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, String name) {
                if (rc != KeeperException.Code.NONODE.intValue()) {
                    callback.processResult(rc, path, ctx, name);
                    return;
                }
                ZkUtils.createFullPathOptimistic(zk, new File(originalPath).getParent().replace("\\", "/"), new byte[0], acl, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                    @Override
                    public void processResult(int rc, String path, Object ctx, String name) {
                        if (rc == KeeperException.Code.OK.intValue() || rc == KeeperException.Code.NODEEXISTS.intValue()) {
                            ZkUtils.createFullPathOptimistic(zk, originalPath, data, acl, createMode, callback, ctx);
                        } else {
                            callback.processResult(rc, path, ctx, name);
                        }
                    }
                }, ctx);
            }
        }, ctx);
    }
}

