/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.util;

import hidden.bkjournal.org.apache.bookkeeper.util.MathUtils;
import hidden.bkjournal.org.apache.bookkeeper.util.SafeRunnable;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OrderedSafeExecutor {
    ExecutorService[] threads;
    Random rand = new Random();

    public OrderedSafeExecutor(int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException();
        }
        this.threads = new ExecutorService[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.threads[i] = Executors.newSingleThreadExecutor();
        }
    }

    ExecutorService chooseThread() {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[this.rand.nextInt(this.threads.length)];
    }

    ExecutorService chooseThread(Object orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[MathUtils.signSafeMod(orderingKey.hashCode(), this.threads.length)];
    }

    public void submit(SafeRunnable r) {
        this.chooseThread().submit(r);
    }

    public void submitOrdered(Object orderingKey, SafeRunnable r) {
        this.chooseThread(orderingKey).submit(r);
    }

    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].shutdown();
        }
    }
}

