/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.proto;

public class ServerStats {
    private static ServerStats instance = new ServerStats();
    private long packetsSent;
    private long packetsReceived;
    private long maxLatency;
    private long minLatency = Long.MAX_VALUE;
    private long totalLatency = 0L;
    private long count = 0L;
    private Provider provider = null;
    private Object mutex = new Object();

    public static ServerStats getInstance() {
        return instance;
    }

    public static void registerAsConcrete() {
        ServerStats.setInstance(new ServerStats());
    }

    public static synchronized void unregister() {
        instance = null;
    }

    protected static synchronized void setInstance(ServerStats newInstance) {
        assert (instance == null);
        instance = newInstance;
    }

    protected ServerStats() {
    }

    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    public synchronized long getAvgLatency() {
        if (this.count != 0L) {
            return this.totalLatency / this.count;
        }
        return 0L;
    }

    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutstandingRequests() {
        Object object = this.mutex;
        synchronized (object) {
            return this.provider != null ? this.provider.getOutstandingRequests() : -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastProcessedZxid() {
        Object object = this.mutex;
        synchronized (object) {
            return this.provider != null ? this.provider.getLastProcessedZxid() : -1L;
        }
    }

    public synchronized long getPacketsReceived() {
        return this.packetsReceived;
    }

    public synchronized long getPacketsSent() {
        return this.packetsSent;
    }

    public String getServerState() {
        return "standalone";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Latency min/avg/max: " + this.getMinLatency() + "/" + this.getAvgLatency() + "/" + this.getMaxLatency() + "\n");
        sb.append("Received: " + this.getPacketsReceived() + "\n");
        sb.append("Sent: " + this.getPacketsSent() + "\n");
        if (this.provider != null) {
            sb.append("Outstanding: " + this.getOutstandingRequests() + "\n");
            sb.append("Zxid: 0x" + Long.toHexString(this.getLastProcessedZxid()) + "\n");
        }
        sb.append("Mode: " + this.getServerState() + "\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatsProvider(Provider zk) {
        Object object = this.mutex;
        synchronized (object) {
            this.provider = zk;
        }
    }

    synchronized void updateLatency(long requestCreateTime) {
        long latency = System.currentTimeMillis() - requestCreateTime;
        this.totalLatency += latency;
        ++this.count;
        if (latency < this.minLatency) {
            this.minLatency = latency;
        }
        if (latency > this.maxLatency) {
            this.maxLatency = latency;
        }
    }

    public synchronized void resetLatency() {
        this.maxLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
        this.minLatency = Long.MAX_VALUE;
    }

    public synchronized void resetMaxLatency() {
        this.maxLatency = this.getMinLatency();
    }

    public synchronized void incrementPacketsReceived() {
        ++this.packetsReceived;
    }

    public synchronized void incrementPacketsSent() {
        ++this.packetsSent;
    }

    public synchronized void resetRequestCounters() {
        this.packetsSent = 0L;
        this.packetsReceived = 0L;
    }

    public static interface Provider {
        public long getOutstandingRequests();

        public long getLastProcessedZxid();
    }
}

