/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.meta;

import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.ZooDefs;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerLayout {
    static final Logger LOG = LoggerFactory.getLogger(LedgerLayout.class);
    public static final String LAYOUT_ZNODE = "LAYOUT";
    public static final int LAYOUT_FORMAT_VERSION = 1;
    static final String splitter = ":";
    static final String lSplitter = "\n";
    private String managerType;
    private int managerVersion;
    private int layoutFormatVersion = 1;

    public static LedgerLayout readLayout(ZooKeeper zk, String ledgersRoot) throws IOException, KeeperException {
        String ledgersLayout = ledgersRoot + "/" + LAYOUT_ZNODE;
        try {
            LedgerLayout layout;
            try {
                byte[] layoutData = zk.getData(ledgersLayout, false, null);
                layout = LedgerLayout.parseLayout(layoutData);
            }
            catch (KeeperException.NoNodeException nne) {
                return null;
            }
            return layout;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public LedgerLayout(String managerType, int managerVersion) {
        this.managerType = managerType;
        this.managerVersion = managerVersion;
    }

    public String getManagerType() {
        return this.managerType;
    }

    public int getManagerVersion() {
        return this.managerVersion;
    }

    public void store(ZooKeeper zk, String ledgersRoot) throws IOException, KeeperException, InterruptedException {
        String ledgersLayout = ledgersRoot + "/" + LAYOUT_ZNODE;
        zk.create(ledgersLayout, this.serialize(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    private byte[] serialize() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.layoutFormatVersion).append(lSplitter).append(this.managerType).append(splitter).append(this.managerVersion);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized layout info: " + sb.toString());
        }
        return sb.toString().getBytes("UTF-8");
    }

    private static LedgerLayout parseLayout(byte[] bytes) throws IOException {
        String layout = new String(bytes, "UTF-8");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing Layout: " + layout);
        }
        String[] lines = layout.split(lSplitter);
        try {
            int layoutFormatVersion = new Integer(lines[0]);
            if (1 != layoutFormatVersion) {
                throw new IOException("Metadata version not compatible. Expected 1, but got " + layoutFormatVersion);
            }
            if (lines.length < 2) {
                throw new IOException("Ledger manager and its version absent from layout: " + layout);
            }
            String[] parts = lines[1].split(splitter);
            if (parts.length != 2) {
                throw new IOException("Invalid Ledger Manager defined in layout : " + layout);
            }
            String managerType = parts[0];
            int managerVersion = new Integer(parts[1]);
            return new LedgerLayout(managerType, managerVersion);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof LedgerLayout)) {
            return false;
        }
        LedgerLayout other = (LedgerLayout)obj;
        return this.managerType.equals(other.managerType) && this.managerVersion == other.managerVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LV").append(this.layoutFormatVersion).append(splitter).append(",Type:").append(this.managerType).append(splitter).append(this.managerVersion);
        return sb.toString();
    }
}

