/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.meta;

import hidden.bkjournal.org.apache.bookkeeper.conf.AbstractConfiguration;
import hidden.bkjournal.org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import hidden.bkjournal.org.apache.bookkeeper.meta.LedgerManager;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.bookkeeper.util.StringUtils;
import hidden.bkjournal.org.apache.bookkeeper.util.ZkUtils;
import hidden.bkjournal.org.apache.zookeeper.AsyncCallback;
import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.ZooDefs;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HierarchicalLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(HierarchicalLedgerManager.class);
    public static final String NAME = "hierarchical";
    public static final int CUR_VERSION = 1;
    static final String IDGENERATION_PREFIX = "/idgen/ID-";
    private static final String MAX_ID_SUFFIX = "9999";
    private static final String MIN_ID_SUFFIX = "0000";
    private final String idGenPath;
    private ConcurrentSkipListMap<Long, Boolean> activeLedgers;
    ScheduledExecutorService scheduler;

    public HierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk, String ledgerRootPath, int layoutVersion) throws IOException {
        super(conf, zk, ledgerRootPath);
        if (layoutVersion != 1) {
            throw new IOException("Incompatible layout version found : " + layoutVersion);
        }
        this.idGenPath = ledgerRootPath + IDGENERATION_PREFIX;
        this.activeLedgers = new ConcurrentSkipListMap();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using HierarchicalLedgerManager with root path : " + ledgerRootPath);
        }
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Error when closing HierarchicalLedgerManager : ", (Throwable)e);
        }
        super.close();
    }

    @Override
    public void newLedgerPath(final BookkeeperInternalCallbacks.GenericCallback<String> ledgerCb) {
        ZkUtils.createFullPathOptimistic(this.zk, this.idGenPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, final String idPathName) {
                long ledgerId;
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Could not generate new ledger id", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    ledgerCb.operationComplete(rc, null);
                    return;
                }
                try {
                    ledgerId = HierarchicalLedgerManager.this.getLedgerIdFromGenPath(idPathName);
                }
                catch (IOException e) {
                    LOG.error("Could not extract ledger-id from id gen path:" + path, (Throwable)e);
                    ledgerCb.operationComplete(KeeperException.Code.SYSTEMERROR.intValue(), null);
                    return;
                }
                AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

                    @Override
                    public void processResult(int rc, String path, Object ctx, String name) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            ledgerCb.operationComplete(rc, null);
                        } else {
                            ledgerCb.operationComplete(rc, name);
                        }
                    }
                };
                String ledgerPath = HierarchicalLedgerManager.this.getLedgerPath(ledgerId);
                ZkUtils.createFullPathOptimistic(HierarchicalLedgerManager.this.zk, ledgerPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, scb, null);
                HierarchicalLedgerManager.this.scheduler.submit(new Runnable(){

                    @Override
                    public void run() {
                        HierarchicalLedgerManager.this.zk.delete(idPathName, -1, new AsyncCallback.VoidCallback(){

                            @Override
                            public void processResult(int rc, String path, Object ctx) {
                                if (rc != KeeperException.Code.OK.intValue()) {
                                    LOG.warn("Exception during deleting znode for id generation : ", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug("Deleting znode for id generation : " + idPathName);
                                }
                            }
                        }, null);
                    }
                });
            }
        }, null);
    }

    private long getLedgerIdFromGenPath(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(IDGENERATION_PREFIX);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        String ledgerIdStr = StringUtils.getZKStringId(ledgerId);
        StringBuilder sb = new StringBuilder();
        sb.append(this.ledgerRootPath).append("/").append(ledgerIdStr.substring(0, 2)).append("/").append(ledgerIdStr.substring(2, 6)).append("/").append("L").append(ledgerIdStr.substring(6, 10));
        return sb.toString();
    }

    @Override
    public long getLedgerId(String pathName) throws IOException {
        if (!pathName.startsWith(this.ledgerRootPath)) {
            throw new IOException("it is not a valid hashed path name : " + pathName);
        }
        String hierarchicalPath = pathName.substring(this.ledgerRootPath.length() + 1);
        String[] hierarchicalParts = hierarchicalPath.split("/");
        if (hierarchicalParts.length != 3) {
            throw new IOException("it is not a valid hierarchical path name : " + pathName);
        }
        hierarchicalParts[2] = hierarchicalParts[2].substring("L".length());
        return this.getLedgerId(hierarchicalParts);
    }

    private long getLedgerId(String ... levelNodes) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            for (String node : levelNodes) {
                sb.append(node);
            }
            return Long.parseLong(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private long getStartLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MIN_ID_SUFFIX);
    }

    private long getEndLedgerIdByLevel(String level1, String level2) throws IOException {
        return this.getLedgerId(level1, level2, MAX_ID_SUFFIX);
    }

    @Override
    public void asyncProcessLedgers(final BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.asyncProcessLevelNodes(this.ledgerRootPath, new BookkeeperInternalCallbacks.Processor<String>(){

            @Override
            public void process(final String l1Node, AsyncCallback.VoidCallback cb1) {
                if (HierarchicalLedgerManager.this.isSpecialZnode(l1Node)) {
                    cb1.processResult(successRc, null, context);
                    return;
                }
                String l1NodePath = HierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node;
                HierarchicalLedgerManager.this.asyncProcessLevelNodes(l1NodePath, new BookkeeperInternalCallbacks.Processor<String>(){

                    @Override
                    public void process(String l2Node, AsyncCallback.VoidCallback cb2) {
                        String l2NodePath = HierarchicalLedgerManager.this.ledgerRootPath + "/" + l1Node + "/" + l2Node;
                        HierarchicalLedgerManager.this.asyncProcessLedgersInSingleNode(l2NodePath, processor, cb2, context, successRc, failureRc);
                    }
                }, cb1, context, successRc, failureRc);
            }
        }, finalCb, context, successRc, failureRc);
    }

    private void asyncProcessLevelNodes(String path, final BookkeeperInternalCallbacks.Processor<String> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.zk.sync(path, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Error syncing path " + path + " when getting its chidren: ", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    finalCb.processResult(failureRc, null, context);
                    return;
                }
                HierarchicalLedgerManager.this.zk.getChildren(path, false, new AsyncCallback.ChildrenCallback(){

                    @Override
                    public void processResult(int rc, String path, Object ctx, List<String> levelNodes) {
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Error polling hash nodes of " + path, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                            finalCb.processResult(failureRc, null, context);
                            return;
                        }
                        AsyncListProcessor<String> listProcessor = new AsyncListProcessor<String>(HierarchicalLedgerManager.this.scheduler);
                        listProcessor.process(levelNodes, processor, finalCb, context, successRc, failureRc);
                    }
                }, null);
            }
        }, null);
    }

    @Override
    public void addActiveLedger(long ledgerId, boolean active) {
        this.activeLedgers.put(ledgerId, active);
    }

    @Override
    public void removeActiveLedger(long ledgerId) {
        this.activeLedgers.remove(ledgerId);
    }

    @Override
    public boolean containsActiveLedger(long ledgerId) {
        return this.activeLedgers.containsKey(ledgerId);
    }

    @Override
    public void garbageCollectLedgers(LedgerManager.GarbageCollector gc) {
        try {
            List<String> l1Nodes = this.zk.getChildren(this.ledgerRootPath, null);
            for (String l1Node : l1Nodes) {
                if (this.isSpecialZnode(l1Node)) continue;
                try {
                    List<String> l2Nodes = this.zk.getChildren(this.ledgerRootPath + "/" + l1Node, null);
                    for (String l2Node : l2Nodes) {
                        this.doGcByLevel(gc, l1Node, l2Node);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception during garbage collecting ledgers for " + l1Node + " of " + this.ledgerRootPath);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception during garbage collecting inactive/deleted ledgers");
        }
    }

    void doGcByLevel(LedgerManager.GarbageCollector gc, String level1, String level2) throws IOException, InterruptedException {
        StringBuilder nodeBuilder = new StringBuilder();
        nodeBuilder.append(this.ledgerRootPath).append("/").append(level1).append("/").append(level2);
        String nodePath = nodeBuilder.toString();
        HashSet<Long> zkActiveLedgers = this.getLedgersInSingleNode(nodePath);
        long startLedgerId = this.getStartLedgerIdByLevel(level1, level2);
        long endLedgerId = this.getEndLedgerIdByLevel(level1, level2);
        NavigableMap bkActiveLedgers = this.activeLedgers.subMap((Object)startLedgerId, true, (Object)endLedgerId, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All active ledgers from ZK for hash node " + level1 + "/" + level2 + " : " + zkActiveLedgers);
            LOG.debug("Current active ledgers from Bookie for hash node " + level1 + "/" + level2 + " : " + bkActiveLedgers);
        }
        this.doGc(gc, (ConcurrentMap<Long, Boolean>)((Object)bkActiveLedgers), zkActiveLedgers);
    }

    void doGc(LedgerManager.GarbageCollector gc, ConcurrentMap<Long, Boolean> bkActiveLedgers, HashSet<Long> zkAllLedgers) {
        for (Long lid : bkActiveLedgers.keySet()) {
            if (zkAllLedgers.contains(lid)) continue;
            bkActiveLedgers.remove(lid);
            gc.gc(lid);
        }
    }

    private static class AsyncListProcessor<T> {
        ScheduledExecutorService scheduler;

        public AsyncListProcessor(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
        }

        public void process(final List<T> data, final BookkeeperInternalCallbacks.Processor<T> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (data == null || data.size() == 0) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            final int size = data.size();
            final AtomicInteger current = new AtomicInteger(0);
            AsyncCallback.VoidCallback stubCallback = new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    if (rc != successRc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    int next = current.incrementAndGet();
                    if (next >= size) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    final Object dataToProcess = data.get(next);
                    final 1 stub = this;
                    AsyncListProcessor.this.scheduler.submit(new Runnable(){

                        @Override
                        public final void run() {
                            processor.process(dataToProcess, stub);
                        }
                    });
                }
            };
            T firstElement = data.get(0);
            processor.process(firstElement, stubCallback);
        }
    }
}

