/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.meta;

import hidden.bkjournal.org.apache.bookkeeper.conf.AbstractConfiguration;
import hidden.bkjournal.org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import hidden.bkjournal.org.apache.bookkeeper.meta.LedgerManager;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.bookkeeper.util.StringUtils;
import hidden.bkjournal.org.apache.bookkeeper.util.ZkUtils;
import hidden.bkjournal.org.apache.zookeeper.AsyncCallback;
import hidden.bkjournal.org.apache.zookeeper.CreateMode;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.ZooDefs;
import hidden.bkjournal.org.apache.zookeeper.ZooKeeper;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlatLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(FlatLedgerManager.class);
    public static final String NAME = "flat";
    public static final int CUR_VERSION = 1;
    private final String ledgerPrefix;
    private ConcurrentMap<Long, Boolean> activeLedgers;

    public FlatLedgerManager(AbstractConfiguration conf, ZooKeeper zk, String ledgerRootPath, int layoutVersion) throws IOException {
        super(conf, zk, ledgerRootPath);
        if (layoutVersion != 1) {
            throw new IOException("Incompatible layout version found : " + layoutVersion);
        }
        this.ledgerPrefix = ledgerRootPath + "/" + "L";
        this.activeLedgers = new ConcurrentHashMap<Long, Boolean>();
    }

    @Override
    public void newLedgerPath(final BookkeeperInternalCallbacks.GenericCallback<String> cb) {
        AsyncCallback.StringCallback scb = new AsyncCallback.StringCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    cb.operationComplete(rc, null);
                } else {
                    cb.operationComplete(rc, name);
                }
            }
        };
        ZkUtils.createFullPathOptimistic(this.zk, this.ledgerPrefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, scb, null);
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ledgerPrefix).append(StringUtils.getZKStringId(ledgerId));
        return sb.toString();
    }

    @Override
    public long getLedgerId(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(this.ledgerPrefix);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object ctx, int successRc, int failureRc) {
        this.asyncProcessLedgersInSingleNode(this.ledgerRootPath, processor, finalCb, ctx, successRc, failureRc);
    }

    @Override
    public void addActiveLedger(long ledgerId, boolean active) {
        this.activeLedgers.put(ledgerId, active);
    }

    @Override
    public void removeActiveLedger(long ledgerId) {
        this.activeLedgers.remove(ledgerId);
    }

    @Override
    public boolean containsActiveLedger(long ledgerId) {
        return this.activeLedgers.containsKey(ledgerId);
    }

    @Override
    public void garbageCollectLedgers(LedgerManager.GarbageCollector gc) {
        try {
            HashSet<Long> zkActiveLedgers = this.getLedgersInSingleNode(this.ledgerRootPath);
            ConcurrentMap<Long, Boolean> bkActiveLedgers = this.activeLedgers;
            if (LOG.isDebugEnabled()) {
                LOG.debug("All active ledgers from ZK: " + zkActiveLedgers);
                LOG.debug("Current active ledgers from Bookie: " + bkActiveLedgers.keySet());
            }
            this.doGc(gc, bkActiveLedgers, zkActiveLedgers);
        }
        catch (IOException ie) {
            LOG.warn("Error during garbage collecting ledgers from " + this.ledgerRootPath, (Throwable)ie);
        }
        catch (InterruptedException inte) {
            LOG.warn("Interrupted during garbage collecting ledgers from " + this.ledgerRootPath, (Throwable)inte);
        }
    }

    void doGc(LedgerManager.GarbageCollector gc, ConcurrentMap<Long, Boolean> bkActiveLedgers, HashSet<Long> zkAllLedgers) {
        for (Long bkLid : bkActiveLedgers.keySet()) {
            if (zkAllLedgers.contains(bkLid)) continue;
            bkActiveLedgers.remove(bkLid);
            gc.gc(bkLid);
        }
    }
}

