/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.client;

import hidden.bkjournal.org.apache.bookkeeper.client.AsyncCallback;
import hidden.bkjournal.org.apache.bookkeeper.client.BKException;
import hidden.bkjournal.org.apache.bookkeeper.client.BookKeeper;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerMetadata;
import java.security.GeneralSecurityException;

class ReadOnlyLedgerHandle
extends LedgerHandle {
    ReadOnlyLedgerHandle(BookKeeper bk, long ledgerId, LedgerMetadata metadata, BookKeeper.DigestType digestType, byte[] password) throws GeneralSecurityException, NumberFormatException {
        super(bk, ledgerId, metadata, digestType, password);
    }

    @Override
    public void close() throws InterruptedException, BKException {
    }

    @Override
    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        cb.closeComplete(0, this, ctx);
    }

    @Override
    public void addEntry(byte[] data) throws InterruptedException, BKException {
        this.addEntry(data, 0, data.length);
    }

    @Override
    public void addEntry(byte[] data, int offset, int length) throws InterruptedException, BKException {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        throw BKException.create(-100);
    }

    @Override
    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        cb.addComplete(-100, this, -1L, ctx);
    }
}

