/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.client;

import hidden.bkjournal.org.apache.bookkeeper.client.AsyncCallback;
import hidden.bkjournal.org.apache.bookkeeper.client.BKException;
import hidden.bkjournal.org.apache.bookkeeper.client.DigestManager;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerRecoveryOp;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLastConfirmedOp
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryOp.class);
    LedgerHandle lh;
    Object ctx;
    int numResponsesPending;
    int validResponses;
    long maxAddConfirmed;
    long maxLength = 0L;
    volatile boolean completed = false;
    AsyncCallback.ReadLastConfirmedCallback cb;

    public ReadLastConfirmedOp(LedgerHandle lh, AsyncCallback.ReadLastConfirmedCallback cb, Object ctx) {
        this.cb = cb;
        this.ctx = ctx;
        this.lh = lh;
        this.validResponses = 0;
        this.numResponsesPending = lh.metadata.ensembleSize;
    }

    public void initiate() {
        for (int i = 0; i < this.lh.metadata.currentEnsemble.size(); ++i) {
            this.lh.bk.bookieClient.readEntry(this.lh.metadata.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i, 0);
        }
    }

    @Override
    public synchronized void readEntryComplete(int rc, long ledgerId, long entryId, ChannelBuffer buffer, Object ctx) {
        int bookieIndex = (Integer)ctx;
        --this.numResponsesPending;
        if (rc == 0) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                this.maxAddConfirmed = Math.max(this.maxAddConfirmed, recoveryData.lastAddConfirmed);
                ++this.validResponses;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch while reading last entry from bookie: " + this.lh.metadata.currentEnsemble.get(bookieIndex));
            }
        }
        if (rc == -7 || rc == -13) {
            ++this.validResponses;
        }
        if (this.validResponses >= this.lh.metadata.quorumSize && !this.completed) {
            this.completed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read Complete with enough validResponses");
            }
            this.cb.readLastConfirmedComplete(0, this.maxAddConfirmed, this.ctx);
            return;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            this.completed = true;
            LOG.error("While readLastConfirmed ledger: " + ledgerId + " did not hear success responses from all quorums");
            this.cb.readLastConfirmedComplete(-10, this.maxAddConfirmed, this.ctx);
        }
    }
}

