/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.client;

import hidden.bkjournal.org.apache.bookkeeper.client.AsyncCallback;
import hidden.bkjournal.org.apache.bookkeeper.client.BookKeeper;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerMetadata;
import hidden.bkjournal.org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.zookeeper.AsyncCallback;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerOpenOp
implements AsyncCallback.DataCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerOpenOp.class);
    final BookKeeper bk;
    final long ledgerId;
    final AsyncCallback.OpenCallback cb;
    final Object ctx;
    LedgerHandle lh;
    final byte[] passwd;
    final BookKeeper.DigestType digestType;
    boolean doRecovery;

    public LedgerOpenOp(BookKeeper bk, long ledgerId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.digestType = digestType;
        this.doRecovery = true;
    }

    public void initiate() {
        this.bk.getZkHandle().getData(this.bk.getLedgerManager().getLedgerPath(this.ledgerId), false, (AsyncCallback.DataCallback)this, this.ctx);
    }

    public void initiateWithoutRecovery() {
        this.doRecovery = false;
        this.initiate();
    }

    @Override
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        LedgerMetadata metadata;
        if (rc == KeeperException.Code.NONODE.intValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No such ledger: " + this.ledgerId, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
            }
            this.cb.openComplete(-7, null, this.ctx);
            return;
        }
        if (rc != KeeperException.Code.OK.intValue()) {
            LOG.error("Could not read metadata for ledger: " + this.ledgerId, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
            this.cb.openComplete(-9, null, this.ctx);
            return;
        }
        try {
            metadata = LedgerMetadata.parseConfig(data, stat.getVersion());
        }
        catch (IOException e) {
            LOG.error("Could not parse ledger metadata for ledger: " + this.ledgerId, (Throwable)e);
            this.cb.openComplete(-9, null, this.ctx);
            return;
        }
        try {
            this.lh = new ReadOnlyLedgerHandle(this.bk, this.ledgerId, metadata, this.digestType, this.passwd);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while opening ledger: " + this.ledgerId, (Throwable)e);
            this.cb.openComplete(-4, null, this.ctx);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.cb.openComplete(-14, null, this.ctx);
            return;
        }
        if (metadata.isClosed()) {
            this.cb.openComplete(0, this.lh, this.ctx);
            return;
        }
        if (this.doRecovery) {
            this.lh.recover(new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                @Override
                public void operationComplete(int rc, Void result) {
                    if (rc != 0) {
                        LedgerOpenOp.this.cb.openComplete(-10, null, LedgerOpenOp.this.ctx);
                    } else {
                        LedgerOpenOp.this.cb.openComplete(0, LedgerOpenOp.this.lh, LedgerOpenOp.this.ctx);
                    }
                }
            });
        } else {
            this.lh.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

                @Override
                public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                    if (rc != 0) {
                        LedgerOpenOp.this.cb.openComplete(-1, null, LedgerOpenOp.this.ctx);
                    } else {
                        LedgerOpenOp.this.lh.lastAddConfirmed = LedgerOpenOp.this.lh.lastAddPushed = lastConfirmed;
                        LedgerOpenOp.this.cb.openComplete(0, LedgerOpenOp.this.lh, LedgerOpenOp.this.ctx);
                    }
                }
            }, null);
        }
    }
}

