/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.client;

import hidden.bkjournal.org.apache.bookkeeper.client.AsyncCallback;
import hidden.bkjournal.org.apache.bookkeeper.client.BKException;
import hidden.bkjournal.org.apache.bookkeeper.client.BookKeeper;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerHandle;
import hidden.bkjournal.org.apache.bookkeeper.client.LedgerMetadata;
import hidden.bkjournal.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import hidden.bkjournal.org.apache.zookeeper.AsyncCallback;
import hidden.bkjournal.org.apache.zookeeper.KeeperException;
import hidden.bkjournal.org.apache.zookeeper.data.Stat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerCreateOp
implements BookkeeperInternalCallbacks.GenericCallback<String>,
AsyncCallback.StatCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCreateOp.class);
    AsyncCallback.CreateCallback cb;
    LedgerMetadata metadata;
    LedgerHandle lh;
    Object ctx;
    byte[] passwd;
    BookKeeper bk;
    BookKeeper.DigestType digestType;

    LedgerCreateOp(BookKeeper bk, int ensembleSize, int quorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.bk = bk;
        this.metadata = new LedgerMetadata(ensembleSize, quorumSize);
        this.digestType = digestType;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
    }

    public void initiate() {
        this.bk.getLedgerManager().newLedgerPath(this);
    }

    @Override
    public void operationComplete(int rc, String ledgerPath) {
        ArrayList<InetSocketAddress> ensemble;
        long ledgerId;
        if (rc != KeeperException.Code.OK.intValue()) {
            LOG.error("Could not create node for ledger", (Throwable)KeeperException.create(KeeperException.Code.get(rc), ledgerPath));
            this.cb.createComplete(-9, null, this.ctx);
            return;
        }
        try {
            ledgerId = this.bk.getLedgerManager().getLedgerId(ledgerPath);
        }
        catch (IOException e) {
            LOG.error("Could not extract ledger-id from path:" + ledgerPath, (Throwable)e);
            this.cb.createComplete(-9, null, this.ctx);
            return;
        }
        try {
            ensemble = this.bk.bookieWatcher.getNewBookies(this.metadata.ensembleSize);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.error("Not enough bookies to create ledger" + ledgerId);
            this.cb.createComplete(e.getCode(), null, this.ctx);
            return;
        }
        this.metadata.addEnsemble(new Long(0L), ensemble);
        try {
            this.lh = new LedgerHandle(this.bk, ledgerId, this.metadata, this.digestType, this.passwd);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while creating ledger: " + ledgerId, (Throwable)e);
            this.cb.createComplete(-4, null, this.ctx);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.cb.createComplete(-14, null, this.ctx);
            return;
        }
        this.lh.writeLedgerConfig(this, null);
    }

    @Override
    public void processResult(int rc, String path, Object ctx, Stat stat) {
        this.metadata.znodeVersion = stat.getVersion();
        this.cb.createComplete(rc, this.lh, this.ctx);
    }
}

