/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.bookie;

import hidden.bkjournal.org.apache.bookkeeper.bookie.Bookie;
import hidden.bkjournal.org.apache.bookkeeper.bookie.EntryLogger;
import hidden.bkjournal.org.apache.bookkeeper.bookie.FileInfo;
import hidden.bkjournal.org.apache.bookkeeper.bookie.LedgerCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDescriptor {
    static final Logger LOG = LoggerFactory.getLogger(LedgerDescriptor.class);
    LedgerCache ledgerCache;
    private ByteBuffer masterKey = null;
    private volatile boolean fenced = false;
    private long ledgerId;
    EntryLogger entryLogger;
    private int refCnt;

    LedgerDescriptor(long ledgerId, EntryLogger entryLogger, LedgerCache ledgerCache) {
        this.ledgerId = ledgerId;
        this.entryLogger = entryLogger;
        this.ledgerCache = ledgerCache;
    }

    void setMasterKey(ByteBuffer masterKey) {
        this.masterKey = masterKey;
    }

    boolean cmpMasterKey(ByteBuffer masterKey) {
        return this.masterKey.equals(masterKey);
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public synchronized void incRef() {
        ++this.refCnt;
    }

    public synchronized void decRef() {
        --this.refCnt;
    }

    public synchronized int getRefCnt() {
        return this.refCnt;
    }

    void setFenced() {
        this.fenced = true;
    }

    boolean isFenced() {
        return this.fenced;
    }

    long addEntry(ByteBuffer entry) throws IOException {
        long ledgerId = entry.getLong();
        if (ledgerId != this.ledgerId) {
            throw new IOException("Entry for ledger " + ledgerId + " was sent to " + this.ledgerId);
        }
        long entryId = entry.getLong();
        entry.rewind();
        long pos = this.entryLogger.addEntry(ledgerId, entry);
        this.ledgerCache.putEntryOffset(ledgerId, entryId, pos);
        return entryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer readEntry(long entryId) throws IOException {
        long offset;
        if (entryId == -1L) {
            long lastEntry;
            block9: {
                lastEntry = this.ledgerCache.getLastEntry(this.ledgerId);
                FileInfo fi = null;
                try {
                    fi = this.ledgerCache.getFileInfo(this.ledgerId, false);
                    long size = fi.size();
                    if (size <= lastEntry * 8L) break block9;
                    ByteBuffer bb = ByteBuffer.allocate(this.ledgerCache.getPageSize());
                    long position = size - (long)this.ledgerCache.getPageSize();
                    if (position < 0L) {
                        position = 0L;
                    }
                    fi.read(bb, position);
                    bb.flip();
                    long startingEntryId = position / 8L;
                    for (int i = this.ledgerCache.getEntriesPerPage() - 1; i >= 0; --i) {
                        if (bb.getLong(i * 8) == 0L) continue;
                        if (lastEntry < startingEntryId + (long)i) {
                            lastEntry = startingEntryId + (long)i;
                        }
                        break;
                    }
                }
                finally {
                    if (fi != null) {
                        fi.release();
                    }
                }
            }
            entryId = lastEntry;
        }
        if ((offset = this.ledgerCache.getEntryOffset(this.ledgerId, entryId)) == 0L) {
            throw new Bookie.NoEntryException(this.ledgerId, entryId);
        }
        return ByteBuffer.wrap(this.entryLogger.readEntry(this.ledgerId, entryId, offset));
    }

    void close() {
    }
}

