/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.bookie;

import hidden.bkjournal.org.apache.bookkeeper.bookie.Bookie;
import hidden.bkjournal.org.apache.bookkeeper.bookie.BufferedChannel;
import hidden.bkjournal.org.apache.bookkeeper.conf.ServerConfiguration;
import hidden.bkjournal.org.apache.bookkeeper.meta.LedgerManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryLogger {
    private static final Logger LOG = LoggerFactory.getLogger(EntryLogger.class);
    private File[] dirs;
    private final Bookie bookie;
    private long logId;
    final long logSizeLimit;
    private volatile BufferedChannel logChannel;
    static final int LOGFILE_HEADER_SIZE = 1024;
    final ByteBuffer LOGFILE_HEADER = ByteBuffer.allocate(1024);
    private volatile boolean somethingWritten = false;
    private ConcurrentMap<Long, ConcurrentHashMap<Long, Boolean>> entryLogs2LedgersMap = new ConcurrentHashMap<Long, ConcurrentHashMap<Long, Boolean>>();
    GarbageCollectorThread gcThread = new GarbageCollectorThread();
    final long gcWaitTime;
    private ConcurrentHashMap<Long, BufferedChannel> channels = new ConcurrentHashMap();

    public EntryLogger(ServerConfiguration conf, Bookie bookie) throws IOException {
        this.dirs = conf.getLedgerDirs();
        this.bookie = bookie;
        this.logSizeLimit = conf.getEntryLogSizeLimit();
        this.gcWaitTime = conf.getGcWaitTime();
        this.LOGFILE_HEADER.put("BKLO".getBytes());
        for (File f : this.dirs) {
            long lastLogId = this.getLastLogId(f);
            if (lastLogId < this.logId) continue;
            this.logId = lastLogId + 1L;
        }
        this.createLogId(this.logId);
        this.gcThread.start();
    }

    private void createLogId(long logId) throws IOException {
        List<File> list = Arrays.asList(this.dirs);
        Collections.shuffle(list);
        File firstDir = list.get(0);
        if (this.logChannel != null) {
            this.logChannel.flush(true);
        }
        this.logChannel = new BufferedChannel(new RandomAccessFile(new File(firstDir, Long.toHexString(logId) + ".log"), "rw").getChannel(), 65536);
        this.logChannel.write((ByteBuffer)this.LOGFILE_HEADER.clear());
        this.channels.put(logId, this.logChannel);
        for (File f : this.dirs) {
            this.setLastLogId(f, logId);
        }
        this.extractLedgersFromEntryLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastLogId(File dir, long logId) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(dir, "lastId"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            bw.write(Long.toHexString(logId) + "\n");
            bw.flush();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastLogId(File f) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(new File(f, "lastId"));
        }
        catch (FileNotFoundException e) {
            return -1L;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        try {
            String lastIdString = br.readLine();
            long l = Long.parseLong(lastIdString);
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        catch (NumberFormatException e) {
            long l = -1L;
            return l;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
    }

    private void openNewChannel() throws IOException {
        this.createLogId(++this.logId);
    }

    synchronized void flush() throws IOException {
        if (this.logChannel != null) {
            this.logChannel.flush(true);
        }
    }

    synchronized long addEntry(long ledger, ByteBuffer entry) throws IOException {
        if (this.logChannel.position() + (long)entry.remaining() + 4L > this.logSizeLimit) {
            this.openNewChannel();
        }
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.putInt(entry.remaining());
        buff.flip();
        this.logChannel.write(buff);
        long pos = this.logChannel.position();
        this.logChannel.write(entry);
        this.somethingWritten = true;
        return this.logId << 32 | pos;
    }

    byte[] readEntry(long ledgerId, long entryId, long location) throws IOException {
        byte[] data;
        ByteBuffer buff;
        int rc;
        BufferedChannel fc;
        long entryLogId = location >> 32;
        long pos = location & 0xFFFFFFFFL;
        ByteBuffer sizeBuff = ByteBuffer.allocate(4);
        pos -= 4L;
        try {
            fc = this.getChannelForLogId(entryLogId);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException newe = new FileNotFoundException(e.getMessage() + " for " + ledgerId + " with location " + location);
            newe.setStackTrace(e.getStackTrace());
            throw newe;
        }
        if (fc.read(sizeBuff, pos) != sizeBuff.capacity()) {
            throw new IOException("Short read from entrylog " + entryLogId);
        }
        pos += 4L;
        sizeBuff.flip();
        int entrySize = sizeBuff.getInt();
        if (entrySize > 0x100000) {
            LOG.error("Sanity check failed for entry size of " + entrySize + " at location " + pos + " in " + entryLogId);
        }
        if ((rc = fc.read(buff = ByteBuffer.wrap(data = new byte[entrySize]), pos)) != data.length) {
            throw new IOException("Short read for " + ledgerId + "@" + entryId + " in " + entryLogId + "@" + pos + "(" + rc + "!=" + data.length + ")");
        }
        buff.flip();
        long thisLedgerId = buff.getLong();
        if (thisLedgerId != ledgerId) {
            throw new IOException("problem found in " + entryLogId + "@" + entryId + " at position + " + pos + " entry belongs to " + thisLedgerId + " not " + ledgerId);
        }
        long thisEntryId = buff.getLong();
        if (thisEntryId != entryId) {
            throw new IOException("problem found in " + entryLogId + "@" + entryId + " at position + " + pos + " entry is " + thisEntryId + " not " + entryId);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedChannel getChannelForLogId(long entryLogId) throws IOException {
        BufferedChannel fc = this.channels.get(entryLogId);
        if (fc != null) {
            return fc;
        }
        File file = this.findFile(entryLogId);
        FileChannel newFc = new RandomAccessFile(file, "rw").getChannel();
        newFc.position(newFc.size());
        ConcurrentHashMap<Long, BufferedChannel> concurrentHashMap = this.channels;
        synchronized (concurrentHashMap) {
            fc = this.channels.get(entryLogId);
            if (fc != null) {
                newFc.close();
                return fc;
            }
            fc = new BufferedChannel(newFc, 8192);
            this.channels.put(entryLogId, fc);
            return fc;
        }
    }

    private File findFile(long logId) throws FileNotFoundException {
        for (File d : this.dirs) {
            File f = new File(d, Long.toHexString(logId) + ".log");
            if (!f.exists()) continue;
            return f;
        }
        throw new FileNotFoundException("No file for log " + Long.toHexString(logId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean testAndClearSomethingWritten() {
        try {
            boolean bl = this.somethingWritten;
            return bl;
        }
        finally {
            this.somethingWritten = false;
        }
    }

    private void extractLedgersFromEntryLogs() throws IOException {
        ByteBuffer sizeBuff = ByteBuffer.allocate(4);
        for (long entryLogId = 0L; entryLogId < this.logId; ++entryLogId) {
            BufferedChannel bc;
            if (this.entryLogs2LedgersMap.containsKey(entryLogId)) continue;
            LOG.info("Extracting the ledgers from entryLogId: " + entryLogId);
            try {
                bc = this.getChannelForLogId(entryLogId);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Entry Log file not found in log directories: " + entryLogId + ".log");
                continue;
            }
            ConcurrentHashMap<Long, Boolean> entryLogLedgers = new ConcurrentHashMap<Long, Boolean>();
            try {
                int entrySize;
                for (long pos = 1024L; pos < bc.size(); pos += (long)entrySize) {
                    byte[] data;
                    ByteBuffer buff;
                    int rc;
                    if (bc.read(sizeBuff, pos) != sizeBuff.capacity()) {
                        throw new IOException("Short read from entrylog " + entryLogId);
                    }
                    pos += 4L;
                    sizeBuff.flip();
                    entrySize = sizeBuff.getInt();
                    if (entrySize > 0x100000) {
                        LOG.error("Sanity check failed for entry size of " + entrySize + " at location " + pos + " in " + entryLogId);
                    }
                    if ((rc = bc.read(buff = ByteBuffer.wrap(data = new byte[entrySize]), pos)) != data.length) {
                        throw new IOException("Short read for entryLog " + entryLogId + "@" + pos + "(" + rc + "!=" + data.length + ")");
                    }
                    buff.flip();
                    long ledgerId = buff.getLong();
                    entryLogLedgers.put(ledgerId, true);
                    sizeBuff.clear();
                }
            }
            catch (IOException e) {
                LOG.info("Premature exception when processing " + entryLogId + "recovery will take care of the problem", (Throwable)e);
            }
            LOG.info("Retrieved all ledgers that comprise entryLogId: " + entryLogId + ", values: " + entryLogLedgers);
            this.entryLogs2LedgersMap.put(entryLogId, entryLogLedgers);
        }
    }

    public void shutdown() throws InterruptedException {
        this.gcThread.running = false;
        this.gcThread.interrupt();
        this.gcThread.join();
        try {
            this.flush();
        }
        catch (IOException ie) {
            LOG.error("Error flush entry log during shutting down, which may cause entry log corrupted.", (Throwable)ie);
        }
    }

    class GarbageCollectorThread
    extends Thread {
        volatile boolean running;

        public GarbageCollectorThread() {
            super("GarbageCollectorThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                GarbageCollectorThread garbageCollectorThread = this;
                synchronized (garbageCollectorThread) {
                    try {
                        this.wait(EntryLogger.this.gcWaitTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                if (((EntryLogger)EntryLogger.this).bookie.zk == null || EntryLogger.this.entryLogs2LedgersMap.isEmpty() || ((EntryLogger)EntryLogger.this).bookie.ledgerCache == null) continue;
                this.doGcLedgers();
                this.doGcEntryLogs();
            }
        }

        private void doGcLedgers() {
            ((EntryLogger)EntryLogger.this).bookie.ledgerCache.activeLedgerManager.garbageCollectLedgers(new LedgerManager.GarbageCollector(){

                @Override
                public void gc(long ledgerId) {
                    try {
                        ((EntryLogger)EntryLogger.this).bookie.ledgerCache.deleteLedger(ledgerId);
                    }
                    catch (IOException e) {
                        LOG.error("Exception when deleting the ledger index file on the Bookie: ", (Throwable)e);
                    }
                }
            });
        }

        private void doGcEntryLogs() {
            for (Long entryLogId : EntryLogger.this.entryLogs2LedgersMap.keySet()) {
                File entryLogFile;
                ConcurrentHashMap entryLogLedgers = (ConcurrentHashMap)EntryLogger.this.entryLogs2LedgersMap.get(entryLogId);
                for (Long entryLogLedger : entryLogLedgers.keySet()) {
                    if (((EntryLogger)EntryLogger.this).bookie.ledgerCache.activeLedgerManager.containsActiveLedger(entryLogLedger)) continue;
                    entryLogLedgers.remove(entryLogLedger);
                }
                if (!entryLogLedgers.isEmpty()) continue;
                LOG.info("Deleting entryLogId " + entryLogId + " as it has no active ledgers!");
                BufferedChannel bc = (BufferedChannel)EntryLogger.this.channels.remove(entryLogId);
                if (null != bc) {
                    try {
                        bc.getFileChannel().close();
                    }
                    catch (IOException ie) {
                        LOG.warn("Exception while closing garbage collected entryLog file : ", (Throwable)ie);
                    }
                }
                try {
                    entryLogFile = EntryLogger.this.findFile(entryLogId);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Trying to delete an entryLog file that could not be found: " + entryLogId + ".log");
                    continue;
                }
                entryLogFile.delete();
                EntryLogger.this.entryLogs2LedgersMap.remove(entryLogId);
            }
        }
    }
}

