/*
 * Decompiled with CFR 0.152.
 */
package hidden.bkjournal.org.apache.bookkeeper.bookie;

public abstract class BookieException
extends Exception {
    private int code;

    public BookieException(int code) {
        this.code = code;
    }

    public static BookieException create(int code) {
        switch (code) {
            case -1: {
                return new BookieUnauthorizedAccessException();
            }
            case -101: {
                return new LedgerFencedException();
            }
        }
        return new BookieIllegalOpException();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(int code) {
        switch (code) {
            case 0: {
                return "No problem";
            }
            case -1: {
                return "Error while reading ledger";
            }
            case -101: {
                return "Ledger has been fenced; No more entries can be added";
            }
        }
        return "Invalid operation";
    }

    public static class LedgerFencedException
    extends BookieException {
        public LedgerFencedException() {
            super(-101);
        }
    }

    public static class BookieIllegalOpException
    extends BookieException {
        public BookieIllegalOpException() {
            super(-1);
        }
    }

    public static class BookieUnauthorizedAccessException
    extends BookieException {
        public BookieUnauthorizedAccessException() {
            super(-1);
        }
    }

    public static interface Code {
        public static final int OK = 0;
        public static final int UnauthorizedAccessException = -1;
        public static final int IllegalOpException = -100;
        public static final int LedgerFencedException = -101;
    }
}

