/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kafka.v09.util;

import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import kafka.message.MessageAndMetadata;
import org.apache.flume.sink.kafka.v09.util.KafkaConsumer;
import org.apache.flume.sink.kafka.v09.util.KafkaLocal;
import org.apache.flume.sink.kafka.v09.util.ZooKeeperLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestUtil.class);
    private static TestUtil instance = new TestUtil();
    private Random randPortGen = new Random(System.currentTimeMillis());
    private KafkaLocal kafkaServer;
    private KafkaConsumer kafkaConsumer;
    private String hostname = "localhost";
    private int kafkaLocalPort;
    private int zkLocalPort;

    private TestUtil() {
        this.init();
    }

    public static TestUtil getInstance() {
        return instance;
    }

    private void init() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Error getting the value of localhost. Proceeding with 'localhost'.", (Throwable)e);
        }
    }

    private boolean startKafkaServer() {
        Properties kafkaProperties = new Properties();
        Properties zkProperties = new Properties();
        logger.info("Starting kafka server.");
        try {
            zkProperties.load(Class.class.getResourceAsStream("/zookeeper.properties"));
            while (true) {
                try {
                    this.zkLocalPort = this.getNextPort();
                    zkProperties.setProperty("clientPort", Integer.toString(this.zkLocalPort));
                    ZooKeeperLocal zookeeper = new ZooKeeperLocal(zkProperties);
                }
                catch (BindException bindEx) {
                    continue;
                }
                break;
            }
            logger.info("ZooKeeper instance is successfully started on port " + this.zkLocalPort);
            kafkaProperties.load(Class.class.getResourceAsStream("/kafka-server.properties"));
            kafkaProperties.setProperty("zookeeper.connect", this.getZkUrl());
            while (true) {
                this.kafkaLocalPort = this.getNextPort();
                kafkaProperties.setProperty("port", Integer.toString(this.kafkaLocalPort));
                this.kafkaServer = new KafkaLocal(kafkaProperties);
                try {
                    this.kafkaServer.start();
                }
                catch (BindException bindEx) {
                    continue;
                }
                break;
            }
            logger.info("Kafka Server is successfully started on port " + this.kafkaLocalPort);
            return true;
        }
        catch (Exception e) {
            logger.error("Error starting the Kafka Server.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaConsumer getKafkaConsumer() {
        TestUtil testUtil = this;
        synchronized (testUtil) {
            if (this.kafkaConsumer == null) {
                this.kafkaConsumer = new KafkaConsumer();
            }
        }
        return this.kafkaConsumer;
    }

    public void initTopicList(List<String> topics) {
        this.getKafkaConsumer().initTopicList(topics);
    }

    public MessageAndMetadata getNextMessageFromConsumer(String topic) {
        return this.getKafkaConsumer().getNextMessage(topic);
    }

    public void prepare() {
        boolean startStatus = this.startKafkaServer();
        if (!startStatus) {
            throw new RuntimeException("Error starting the server!");
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getKafkaConsumer();
        logger.info("Completed the prepare phase.");
    }

    public void tearDown() {
        logger.info("Shutting down the Kafka Consumer.");
        this.getKafkaConsumer().shutdown();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("Shutting down the kafka Server.");
        this.kafkaServer.stop();
        logger.info("Completed the tearDown phase.");
    }

    private synchronized int getNextPort() {
        return this.randPortGen.nextInt(16383) + 49152;
    }

    public String getZkUrl() {
        return this.hostname + ":" + this.zkLocalPort;
    }

    public String getKafkaServerUrl() {
        return this.hostname + ":" + this.kafkaLocalPort;
    }
}

