/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.hbase.HbaseEventSerializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSink
extends AbstractSink
implements Configurable {
    private String tableName;
    private byte[] columnFamily;
    private HTable table;
    private long batchSize;
    private Configuration config;
    private CounterGroup counterGroup = new CounterGroup();
    private static final Logger logger = LoggerFactory.getLogger(HBaseSink.class);
    private HbaseEventSerializer serializer;
    private String eventSerializerType;
    private Context serializerContext;

    public HBaseSink() {
        this(HBaseConfiguration.create());
    }

    public HBaseSink(Configuration conf) {
        this.config = conf;
    }

    public void start() {
        Preconditions.checkArgument((this.table == null ? 1 : 0) != 0, (Object)"Please call stop before calling start on an old instance.");
        try {
            this.table = new HTable(this.config, this.tableName);
            this.table.setAutoFlush(false);
        }
        catch (IOException e) {
            logger.error("Could not load table, " + this.tableName + " from HBase", (Throwable)e);
            throw new FlumeException("Could not load table, " + this.tableName + " from HBase", (Throwable)e);
        }
        try {
            if (!this.table.getTableDescriptor().hasFamily(this.columnFamily)) {
                throw new IOException("Table " + this.tableName + " has no such column family " + Bytes.toString((byte[])this.columnFamily));
            }
        }
        catch (IOException e) {
            throw new FlumeException("Error getting column family from HBase.Please verify that the table " + this.tableName + " and Column Family, " + Bytes.toString((byte[])this.columnFamily) + " exists in HBase.", (Throwable)e);
        }
        super.start();
    }

    public void stop() {
        try {
            this.table.close();
            this.table = null;
        }
        catch (IOException e) {
            throw new FlumeException("Error closing table.", (Throwable)e);
        }
    }

    public void configure(Context context) {
        this.tableName = context.getString("table");
        String cf = context.getString("columnFamily");
        this.batchSize = context.getLong("batchSize", new Long(100L));
        this.serializerContext = new Context();
        this.eventSerializerType = context.getString("serializer");
        Preconditions.checkNotNull((Object)this.tableName, (Object)"Table name cannot be empty, please specify in configuration file");
        Preconditions.checkNotNull((Object)cf, (Object)"Column family cannot be empty, please specify in configuration file");
        if (this.eventSerializerType == null || this.eventSerializerType.isEmpty()) {
            this.eventSerializerType = "org.apache.flume.sink.hbase.SimpleHbaseEventSerializer";
            logger.info("No serializer defined, Will use default");
        }
        this.serializerContext.putAll((Map)context.getSubProperties("serializer."));
        this.columnFamily = cf.getBytes(Charsets.UTF_8);
        try {
            Class<?> clazz = Class.forName(this.eventSerializerType);
            this.serializer = (HbaseEventSerializer)clazz.newInstance();
            this.serializer.configure(this.serializerContext);
        }
        catch (Exception e) {
            logger.error("Could not instantiate event serializer.", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction txn = channel.getTransaction();
        LinkedList<Row> actions = new LinkedList<Row>();
        LinkedList<Increment> incs = new LinkedList<Increment>();
        txn.begin();
        for (long i = 0L; i < this.batchSize; ++i) {
            Event event = channel.take();
            if (event == null) {
                status = Sink.Status.BACKOFF;
                this.counterGroup.incrementAndGet("channel.underflow");
                break;
            }
            this.serializer.initialize(event, this.columnFamily);
            actions.addAll(this.serializer.getActions());
            incs.addAll(this.serializer.getIncrements());
        }
        this.putEventsAndCommit(actions, incs, txn);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEventsAndCommit(List<Row> actions, List<Increment> incs, Transaction txn) throws EventDeliveryException {
        block9: {
            try {
                this.table.batch(actions);
                for (Increment i : incs) {
                    this.table.increment(i);
                }
                txn.commit();
                this.counterGroup.incrementAndGet("transaction.success");
            }
            catch (Throwable e) {
                try {
                    txn.rollback();
                }
                catch (Exception e2) {
                    logger.error("Exception in rollback. Rollback might not have beensuccessful.", (Throwable)e2);
                }
                this.counterGroup.incrementAndGet("transaction.rollback");
                logger.error("Failed to commit transaction.Transaction rolled back.", e);
                if (e instanceof Error || e instanceof RuntimeException) {
                    logger.error("Failed to commit transaction.Transaction rolled back.", e);
                    Throwables.propagate((Throwable)e);
                    break block9;
                }
                logger.error("Failed to commit transaction.Transaction rolled back.", e);
                throw new EventDeliveryException("Failed to commit transaction.Transaction rolled back.", e);
            }
            finally {
                txn.close();
            }
        }
    }
}

