/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import java.io.IOException;
import java.nio.charset.Charset;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class ContentBuilderUtil {
    private static final Charset charset = Charset.defaultCharset();

    private ContentBuilderUtil() {
    }

    public static void appendField(XContentBuilder builder, String field, byte[] data) throws IOException {
        XContentType contentType = XContentFactory.xContentType((byte[])data);
        if (contentType == null) {
            ContentBuilderUtil.addSimpleField(builder, field, data);
        } else {
            ContentBuilderUtil.addComplexField(builder, field, contentType, data);
        }
    }

    public static void addSimpleField(XContentBuilder builder, String fieldName, byte[] data) throws IOException {
        builder.field(fieldName, new String(data, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addComplexField(XContentBuilder builder, String fieldName, XContentType contentType, byte[] data) throws IOException {
        XContentParser parser = XContentFactory.xContent((XContentType)contentType).createParser(data);
        parser.nextToken();
        builder.field(fieldName);
        try {
            builder.copyCurrentStructure(parser);
        }
        catch (JsonParseException ex) {
            builder.endObject();
            builder.field(fieldName, new String(data, charset));
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

