/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.apache.flume.sink.elasticsearch.ElasticSearchIndexRequestBuilderFactory;
import org.apache.flume.sink.elasticsearch.IndexNameBuilder;
import org.apache.flume.sink.elasticsearch.client.ElasticSearchClient;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchTransportClient
implements ElasticSearchClient {
    public static final Logger logger = LoggerFactory.getLogger(ElasticSearchTransportClient.class);
    private InetSocketTransportAddress[] serverAddresses;
    private ElasticSearchEventSerializer serializer;
    private ElasticSearchIndexRequestBuilderFactory indexRequestBuilderFactory;
    private BulkRequestBuilder bulkRequestBuilder;
    private Client client;

    @VisibleForTesting
    InetSocketTransportAddress[] getServerAddresses() {
        return this.serverAddresses;
    }

    @VisibleForTesting
    void setBulkRequestBuilder(BulkRequestBuilder bulkRequestBuilder) {
        this.bulkRequestBuilder = bulkRequestBuilder;
    }

    public ElasticSearchTransportClient(String[] hostNames, String clusterName, ElasticSearchEventSerializer serializer) {
        this.configureHostnames(hostNames);
        this.serializer = serializer;
        this.openClient(clusterName);
    }

    public ElasticSearchTransportClient(String[] hostNames, String clusterName, ElasticSearchIndexRequestBuilderFactory indexBuilder) {
        this.configureHostnames(hostNames);
        this.indexRequestBuilderFactory = indexBuilder;
        this.openClient(clusterName);
    }

    public ElasticSearchTransportClient(ElasticSearchIndexRequestBuilderFactory indexBuilderFactory) {
        this.indexRequestBuilderFactory = indexBuilderFactory;
        this.openLocalDiscoveryClient();
    }

    public ElasticSearchTransportClient(ElasticSearchEventSerializer serializer) {
        this.serializer = serializer;
        this.openLocalDiscoveryClient();
    }

    public ElasticSearchTransportClient(Client client, ElasticSearchEventSerializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }

    public ElasticSearchTransportClient(Client client, ElasticSearchIndexRequestBuilderFactory requestBuilderFactory) throws IOException {
        this.client = client;
        requestBuilderFactory.createIndexRequest(client, null, null, null);
    }

    private void configureHostnames(String[] hostNames) {
        logger.warn(Arrays.toString(hostNames));
        this.serverAddresses = new InetSocketTransportAddress[hostNames.length];
        for (int i = 0; i < hostNames.length; ++i) {
            String[] hostPort = hostNames[i].trim().split(":");
            String host = hostPort[0].trim();
            int port = hostPort.length == 2 ? Integer.parseInt(hostPort[1].trim()) : 9300;
            this.serverAddresses[i] = new InetSocketTransportAddress(host, port);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
    }

    @Override
    public void addEvent(Event event, IndexNameBuilder indexNameBuilder, String indexType, long ttlMs) throws Exception {
        if (this.bulkRequestBuilder == null) {
            this.bulkRequestBuilder = this.client.prepareBulk();
        }
        IndexRequestBuilder indexRequestBuilder = null;
        indexRequestBuilder = this.indexRequestBuilderFactory == null ? this.client.prepareIndex(indexNameBuilder.getIndexName(event), indexType).setSource(this.serializer.getContentBuilder(event).bytes()) : this.indexRequestBuilderFactory.createIndexRequest(this.client, indexNameBuilder.getIndexPrefix(event), indexType, event);
        if (ttlMs > 0L) {
            indexRequestBuilder.setTTL(ttlMs);
        }
        this.bulkRequestBuilder.add(indexRequestBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        try {
            logger.info("Sending bulk to elasticsearch cluster");
            BulkResponse bulkResponse = (BulkResponse)this.bulkRequestBuilder.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                throw new EventDeliveryException(bulkResponse.buildFailureMessage());
            }
        }
        finally {
            this.bulkRequestBuilder = this.client.prepareBulk();
        }
    }

    private void openClient(String clusterName) {
        logger.info("Using ElasticSearch hostnames: {} ", (Object)Arrays.toString(this.serverAddresses));
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).build();
        TransportClient transportClient = new TransportClient(settings);
        for (InetSocketTransportAddress host : this.serverAddresses) {
            transportClient.addTransportAddress((TransportAddress)host);
        }
        if (this.client != null) {
            this.client.close();
        }
        this.client = transportClient;
    }

    private void openLocalDiscoveryClient() {
        logger.info("Using ElasticSearch AutoDiscovery mode");
        Node node = NodeBuilder.nodeBuilder().client(true).local(true).node();
        if (this.client != null) {
            this.client.close();
        }
        this.client = node.client();
    }

    public void configure(Context context) {
    }
}

