/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.apache.flume.sink.elasticsearch.IndexNameBuilder;
import org.apache.flume.sink.elasticsearch.client.ElasticSearchClient;
import org.apache.flume.sink.elasticsearch.client.RoundRobinList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.bytes.BytesReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
implements ElasticSearchClient {
    private static final String INDEX_OPERATION_NAME = "index";
    private static final String INDEX_PARAM = "_index";
    private static final String TYPE_PARAM = "_type";
    private static final String TTL_PARAM = "_ttl";
    private static final String BULK_ENDPOINT = "_bulk";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);
    private final ElasticSearchEventSerializer serializer;
    private final RoundRobinList<String> serversList;
    private StringBuilder bulkBuilder;
    private HttpClient httpClient;

    public ElasticSearchRestClient(String[] hostNames, ElasticSearchEventSerializer serializer) {
        for (int i = 0; i < hostNames.length; ++i) {
            if (hostNames[i].contains("http://") || hostNames[i].contains("https://")) continue;
            hostNames[i] = "http://" + hostNames[i];
        }
        this.serializer = serializer;
        this.serversList = new RoundRobinList<String>(Arrays.asList(hostNames));
        this.httpClient = new DefaultHttpClient();
        this.bulkBuilder = new StringBuilder();
    }

    @VisibleForTesting
    public ElasticSearchRestClient(String[] hostNames, ElasticSearchEventSerializer serializer, HttpClient client) {
        this(hostNames, serializer);
        this.httpClient = client;
    }

    public void configure(Context context) {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEvent(Event event, IndexNameBuilder indexNameBuilder, String indexType, long ttlMs) throws Exception {
        BytesReference content = this.serializer.getContentBuilder(event).bytes();
        HashMap parameters = new HashMap();
        HashMap<String, String> indexParameters = new HashMap<String, String>();
        indexParameters.put(INDEX_PARAM, indexNameBuilder.getIndexName(event));
        indexParameters.put(TYPE_PARAM, indexType);
        if (ttlMs > 0L) {
            indexParameters.put(TTL_PARAM, Long.toString(ttlMs));
        }
        parameters.put(INDEX_OPERATION_NAME, indexParameters);
        Gson gson = new Gson();
        StringBuilder stringBuilder = this.bulkBuilder;
        synchronized (stringBuilder) {
            this.bulkBuilder.append(gson.toJson(parameters));
            this.bulkBuilder.append("\n");
            this.bulkBuilder.append(content.toBytesArray().toUtf8());
            this.bulkBuilder.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        String entity;
        int statusCode = 0;
        HttpResponse response = null;
        logger.info("Sending bulk request to elasticsearch cluster");
        StringBuilder stringBuilder = this.bulkBuilder;
        synchronized (stringBuilder) {
            entity = this.bulkBuilder.toString();
            this.bulkBuilder = new StringBuilder();
        }
        for (int triesCount = 0; statusCode != 200 && triesCount < this.serversList.size(); ++triesCount) {
            String host = this.serversList.get();
            String url = host + "/" + BULK_ENDPOINT;
            HttpPost httpRequest = new HttpPost(url);
            httpRequest.setEntity((HttpEntity)new StringEntity(entity));
            response = this.httpClient.execute((HttpUriRequest)httpRequest);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info("Status code from elasticsearch: " + statusCode);
            if (response.getEntity() == null) continue;
            logger.debug("Status message from elasticsearch: " + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        if (statusCode != 200) {
            if (response.getEntity() != null) {
                throw new EventDeliveryException(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            throw new EventDeliveryException("Elasticsearch status code was: " + statusCode);
        }
    }
}

