/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.elasticsearch.IndexNameBuilder;
import org.apache.flume.sink.elasticsearch.TimestampedEvent;

public class TimeBasedIndexNameBuilder
implements IndexNameBuilder {
    public static final String DATE_FORMAT = "dateFormat";
    public static final String TIME_ZONE = "timeZone";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_ZONE = "Etc/UTC";
    private FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)TimeZone.getTimeZone("Etc/UTC"));
    private String indexPrefix;

    @VisibleForTesting
    FastDateFormat getFastDateFormat() {
        return this.fastDateFormat;
    }

    @Override
    public String getIndexName(Event event) {
        TimestampedEvent timestampedEvent = new TimestampedEvent(event);
        long timestamp = timestampedEvent.getTimestamp();
        return this.indexPrefix + '-' + this.fastDateFormat.format(timestamp);
    }

    @Override
    public String getIndexPrefix(Event event) {
        return this.indexPrefix;
    }

    public void configure(Context context) {
        String dateFormatString = context.getString(DATE_FORMAT);
        String timeZoneString = context.getString(TIME_ZONE);
        if (StringUtils.isBlank((String)dateFormatString)) {
            dateFormatString = DEFAULT_DATE_FORMAT;
        }
        if (StringUtils.isBlank((String)timeZoneString)) {
            timeZoneString = DEFAULT_TIME_ZONE;
        }
        this.fastDateFormat = FastDateFormat.getInstance((String)dateFormatString, (TimeZone)TimeZone.getTimeZone(timeZoneString));
        this.indexPrefix = context.getString("indexName");
    }

    public void configure(ComponentConfiguration conf) {
    }
}

