/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.elasticsearch.ContentBuilderUtil;
import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchLogStashEventSerializer
implements ElasticSearchEventSerializer {
    @Override
    public XContentBuilder getContentBuilder(Event event) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        this.appendBody(builder, event);
        this.appendHeaders(builder, event);
        return builder;
    }

    private void appendBody(XContentBuilder builder, Event event) throws IOException, UnsupportedEncodingException {
        byte[] body = event.getBody();
        ContentBuilderUtil.appendField(builder, "@message", body);
    }

    private void appendHeaders(XContentBuilder builder, Event event) throws IOException {
        String srcPath;
        String host;
        String type;
        String source;
        HashMap headers = Maps.newHashMap((Map)event.getHeaders());
        String timestamp = (String)headers.get("timestamp");
        if (!StringUtils.isBlank((String)timestamp) && StringUtils.isBlank((String)((String)headers.get("@timestamp")))) {
            long timestampMs = Long.parseLong(timestamp);
            builder.field("@timestamp", new Date(timestampMs));
        }
        if (!StringUtils.isBlank((String)(source = (String)headers.get("source"))) && StringUtils.isBlank((String)((String)headers.get("@source")))) {
            ContentBuilderUtil.appendField(builder, "@source", source.getBytes(charset));
        }
        if (!StringUtils.isBlank((String)(type = (String)headers.get("type"))) && StringUtils.isBlank((String)((String)headers.get("@type")))) {
            ContentBuilderUtil.appendField(builder, "@type", type.getBytes(charset));
        }
        if (!StringUtils.isBlank((String)(host = (String)headers.get("host"))) && StringUtils.isBlank((String)((String)headers.get("@source_host")))) {
            ContentBuilderUtil.appendField(builder, "@source_host", host.getBytes(charset));
        }
        if (!StringUtils.isBlank((String)(srcPath = (String)headers.get("src_path"))) && StringUtils.isBlank((String)((String)headers.get("@source_path")))) {
            ContentBuilderUtil.appendField(builder, "@source_path", srcPath.getBytes(charset));
        }
        builder.startObject("@fields");
        for (String key : headers.keySet()) {
            byte[] val = ((String)headers.get(key)).getBytes(charset);
            ContentBuilderUtil.appendField(builder, key, val);
        }
        builder.endObject();
    }

    public void configure(Context context) {
    }

    public void configure(ComponentConfiguration conf) {
    }
}

