/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.serialization.EventSerializerFactory;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;

public class HDFSDataStream
implements HDFSWriter {
    private FSDataOutputStream outStream;
    private String serializerType;
    private Context serializerContext;
    private EventSerializer serializer;

    public void configure(Context context) {
        this.serializerType = context.getString("serializer", "TEXT");
        this.serializerContext = new Context((Map)context.getSubProperties("serializer."));
    }

    @Override
    public void open(String filePath, FlumeFormatter fmt) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = dstPath.getFileSystem(conf);
        boolean appending = false;
        if (conf.getBoolean("hdfs.append.support", false) && hdfs.isFile(dstPath)) {
            this.outStream = hdfs.append(dstPath);
            appending = true;
        } else {
            this.outStream = hdfs.create(dstPath);
        }
        this.serializer = EventSerializerFactory.getInstance((String)this.serializerType, (Context)this.serializerContext, (OutputStream)this.outStream);
        if (appending && !this.serializer.supportsReopen()) {
            this.outStream.close();
            this.serializer = null;
            throw new IOException("serializer (" + this.serializerType + ") does not support append");
        }
        if (appending) {
            this.serializer.afterReopen();
        } else {
            this.serializer.afterCreate();
        }
    }

    @Override
    public void open(String filePath, CompressionCodec codec, SequenceFile.CompressionType cType, FlumeFormatter fmt) throws IOException {
        this.open(filePath, fmt);
    }

    @Override
    public void append(Event e, FlumeFormatter fmt) throws IOException {
        this.serializer.write(e);
    }

    @Override
    public void sync() throws IOException {
        this.serializer.flush();
        this.outStream.flush();
        this.outStream.sync();
    }

    @Override
    public void close() throws IOException {
        this.serializer.flush();
        this.serializer.beforeClose();
        this.outStream.flush();
        this.outStream.sync();
        this.outStream.close();
    }
}

