/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.CounterGroup;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.PropertiesFileConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingPropertiesFileConfigurationProvider
extends PropertiesFileConfigurationProvider
implements LifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingPropertiesFileConfigurationProvider.class);
    private final EventBus eventBus;
    private final File file;
    private final int interval;
    private final CounterGroup counterGroup;
    private LifecycleState lifecycleState;
    private ScheduledExecutorService executorService;

    public PollingPropertiesFileConfigurationProvider(String agentName, File file, EventBus eventBus, int interval) {
        super(agentName, file);
        this.eventBus = eventBus;
        this.file = file;
        this.interval = interval;
        this.counterGroup = new CounterGroup();
        this.lifecycleState = LifecycleState.IDLE;
    }

    public void start() {
        LOGGER.info("Configuration provider starting");
        Preconditions.checkState((this.file != null ? 1 : 0) != 0, (Object)"The parameter file must not be null");
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("conf-file-poller-%d").build());
        FileWatcherRunnable fileWatcherRunnable = new FileWatcherRunnable(this.file, this.counterGroup);
        this.executorService.scheduleWithFixedDelay(fileWatcherRunnable, 0L, this.interval, TimeUnit.SECONDS);
        this.lifecycleState = LifecycleState.START;
        LOGGER.debug("Configuration provider started");
    }

    public void stop() {
        LOGGER.info("Configuration provider stopping");
        this.executorService.shutdown();
        try {
            while (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                LOGGER.debug("Waiting for file watcher to terminate");
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted while waiting for file watcher to terminate");
            Thread.currentThread().interrupt();
        }
        this.lifecycleState = LifecycleState.STOP;
        LOGGER.debug("Configuration provider stopped");
    }

    public synchronized LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return "{ file:" + this.file + " counterGroup:" + this.counterGroup + "  provider:" + this.getClass().getCanonicalName() + " agentName:" + this.getAgentName() + " }";
    }

    public class FileWatcherRunnable
    implements Runnable {
        private final File file;
        private final CounterGroup counterGroup;
        private long lastChange;

        public FileWatcherRunnable(File file, CounterGroup counterGroup) {
            this.file = file;
            this.counterGroup = counterGroup;
            this.lastChange = 0L;
        }

        @Override
        public void run() {
            LOGGER.debug("Checking file:{} for changes", (Object)this.file);
            this.counterGroup.incrementAndGet("file.checks");
            long lastModified = this.file.lastModified();
            if (lastModified > this.lastChange) {
                LOGGER.info("Reloading configuration file:{}", (Object)this.file);
                this.counterGroup.incrementAndGet("file.loads");
                this.lastChange = lastModified;
                try {
                    PollingPropertiesFileConfigurationProvider.this.eventBus.post((Object)PollingPropertiesFileConfigurationProvider.this.getConfiguration());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load configuration data. Exception follows.", (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    LOGGER.error("Failed to start agent because dependencies were not found in classpath. Error follows.", (Throwable)e);
                }
                catch (Throwable t) {
                    LOGGER.error("Unhandled error", t);
                }
            }
        }
    }
}

