/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.agent.embedded;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flume.FlumeException;
import org.apache.flume.agent.embedded.EmbeddedSource;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.conf.channel.ChannelType;
import org.apache.flume.conf.sink.SinkProcessorType;
import org.apache.flume.conf.sink.SinkType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EmbeddedAgentConfiguration {
    public static final String SEPERATOR = ".";
    private static final Joiner JOINER = Joiner.on((String)".");
    private static final String TYPE = "type";
    public static final String SOURCE = "source";
    public static final String CHANNEL = "channel";
    public static final String SINK_PROCESSOR = "processor";
    public static final String SINKS = "sinks";
    public static final String SINKS_PREFIX = EmbeddedAgentConfiguration.join("sinks", "");
    public static final String SOURCE_TYPE = EmbeddedAgentConfiguration.join("source", "type");
    public static final String SOURCE_PREFIX = EmbeddedAgentConfiguration.join("source", "");
    public static final String CHANNEL_TYPE = EmbeddedAgentConfiguration.join("channel", "type");
    public static final String CHANNEL_PREFIX = EmbeddedAgentConfiguration.join("channel", "");
    public static final String SINK_PROCESSOR_TYPE = EmbeddedAgentConfiguration.join("processor", "type");
    public static final String SINK_PROCESSOR_PREFIX = EmbeddedAgentConfiguration.join("processor", "");
    public static final String SOURCE_TYPE_EMBEDDED = EmbeddedSource.class.getName();
    private static final String SOURCE_TYPE_EMBEDDED_ALIAS = "EMBEDDED";
    public static final String CHANNEL_TYPE_MEMORY = ChannelType.MEMORY.name();
    public static final String CHANNEL_TYPE_FILE = ChannelType.FILE.name();
    public static final String SINK_TYPE_AVRO = SinkType.AVRO.name();
    public static final String SINK_PROCESSOR_TYPE_DEFAULT = SinkProcessorType.DEFAULT.name();
    public static final String SINK_PROCESSOR_TYPE_FAILOVER = SinkProcessorType.FAILOVER.name();
    public static final String SINK_PROCESSOR_TYPE_LOAD_BALANCE = SinkProcessorType.LOAD_BALANCE.name();
    private static final String[] ALLOWED_SOURCES = new String[]{"EMBEDDED", SOURCE_TYPE_EMBEDDED};
    private static final String[] ALLOWED_CHANNELS = new String[]{CHANNEL_TYPE_MEMORY, CHANNEL_TYPE_FILE};
    private static final String[] ALLOWED_SINKS = new String[]{SINK_TYPE_AVRO};
    private static final String[] ALLOWED_SINK_PROCESSORS = new String[]{SINK_PROCESSOR_TYPE_DEFAULT, SINK_PROCESSOR_TYPE_FAILOVER, SINK_PROCESSOR_TYPE_LOAD_BALANCE};
    private static final ImmutableList<String> DISALLOWED_SINK_NAMES = ImmutableList.of((Object)"source", (Object)"channel", (Object)"processor");

    private static void validate(String name, Map<String, String> properties) throws FlumeException {
        if (properties.containsKey(SOURCE_TYPE)) {
            EmbeddedAgentConfiguration.checkAllowed(ALLOWED_SOURCES, properties.get(SOURCE_TYPE));
        }
        EmbeddedAgentConfiguration.checkRequired(properties, CHANNEL_TYPE);
        EmbeddedAgentConfiguration.checkAllowed(ALLOWED_CHANNELS, properties.get(CHANNEL_TYPE));
        EmbeddedAgentConfiguration.checkRequired(properties, SINKS);
        String sinkNames = properties.get(SINKS);
        for (String sink : sinkNames.split("\\s+")) {
            if (DISALLOWED_SINK_NAMES.contains((Object)sink.toLowerCase())) {
                throw new FlumeException("Sink name " + sink + " is one of the" + " disallowed sink names: " + DISALLOWED_SINK_NAMES);
            }
            String key = EmbeddedAgentConfiguration.join(sink, TYPE);
            EmbeddedAgentConfiguration.checkRequired(properties, key);
            EmbeddedAgentConfiguration.checkAllowed(ALLOWED_SINKS, properties.get(key));
        }
        EmbeddedAgentConfiguration.checkRequired(properties, SINK_PROCESSOR_TYPE);
        EmbeddedAgentConfiguration.checkAllowed(ALLOWED_SINK_PROCESSORS, properties.get(SINK_PROCESSOR_TYPE));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static Map<String, String> configure(String name, Map<String, String> properties) throws FlumeException {
        EmbeddedAgentConfiguration.validate(name, properties);
        properties = new HashMap<String, String>(properties);
        if (!properties.containsKey(SOURCE_TYPE) || SOURCE_TYPE_EMBEDDED_ALIAS.equalsIgnoreCase(properties.get(SOURCE_TYPE))) {
            properties.put(SOURCE_TYPE, SOURCE_TYPE_EMBEDDED);
        }
        String sinkNames = properties.remove(SINKS);
        String sourceName = "source-" + name;
        String channelName = "channel-" + name;
        String sinkGroupName = "sink-group-" + name;
        HashMap result = Maps.newHashMap();
        result.put(EmbeddedAgentConfiguration.join(name, "sources"), sourceName);
        result.put(EmbeddedAgentConfiguration.join(name, "channels"), channelName);
        result.put(EmbeddedAgentConfiguration.join(name, SINKS), sinkNames);
        result.put(EmbeddedAgentConfiguration.join(name, "sinkgroups"), sinkGroupName);
        result.put(EmbeddedAgentConfiguration.join(name, "sinkgroups", sinkGroupName, SINKS), sinkNames);
        result.put(EmbeddedAgentConfiguration.join(name, "sources", sourceName, "channels"), channelName);
        HashSet<String> userProvidedKeys = new HashSet<String>(properties.keySet());
        for (String sink : sinkNames.split("\\s+")) {
            for (String key : userProvidedKeys) {
                String value = properties.get(key);
                if (!key.startsWith(sink + SEPERATOR)) continue;
                properties.remove(key);
                result.put(EmbeddedAgentConfiguration.join(name, SINKS, key), value);
            }
            result.put(EmbeddedAgentConfiguration.join(name, SINKS, sink, CHANNEL), channelName);
        }
        userProvidedKeys = new HashSet<String>(properties.keySet());
        for (String key : userProvidedKeys) {
            String value = properties.get(key);
            if (key.startsWith(SOURCE_PREFIX)) {
                key = key.replaceFirst(SOURCE, sourceName);
                result.put(EmbeddedAgentConfiguration.join(name, "sources", key), value);
                continue;
            }
            if (key.startsWith(CHANNEL_PREFIX)) {
                key = key.replaceFirst(CHANNEL, channelName);
                result.put(EmbeddedAgentConfiguration.join(name, "channels", key), value);
                continue;
            }
            if (key.startsWith(SINK_PROCESSOR_PREFIX)) {
                result.put(EmbeddedAgentConfiguration.join(name, "sinkgroups", sinkGroupName, key), value);
                continue;
            }
            throw new FlumeException("Unknown configuration " + key);
        }
        return result;
    }

    private static void checkAllowed(String[] allowedTypes, String type) {
        boolean isAllowed = false;
        type = type.trim();
        for (String allowedType : allowedTypes) {
            if (!allowedType.equalsIgnoreCase(type)) continue;
            isAllowed = true;
            break;
        }
        if (!isAllowed) {
            throw new FlumeException("Component type of " + type + " is not in " + "allowed types of " + Arrays.toString(allowedTypes));
        }
    }

    private static void checkRequired(Map<String, String> properties, String name) {
        if (!properties.containsKey(name)) {
            throw new FlumeException("Required parameter not found " + name);
        }
    }

    private static String join(String ... parts) {
        return JOINER.join((Object[])parts);
    }

    private EmbeddedAgentConfiguration() {
    }
}

