/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ControlledShutdownResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String PARTITIONS_REMAINING_KEY_NAME = "partitions_remaining";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private final short errorCode;
    private final Set<TopicPartition> partitionsRemaining;

    public ControlledShutdownResponse(short errorCode, Set<TopicPartition> partitionsRemaining) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        ArrayList partitionsRemainingList = new ArrayList(partitionsRemaining.size());
        for (TopicPartition topicPartition : partitionsRemaining) {
            Struct topicPartitionStruct = this.struct.instance(PARTITIONS_REMAINING_KEY_NAME);
            topicPartitionStruct.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            topicPartitionStruct.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
        }
        this.struct.set(PARTITIONS_REMAINING_KEY_NAME, (Object)partitionsRemainingList.toArray());
        this.errorCode = errorCode;
        this.partitionsRemaining = partitionsRemaining;
    }

    public ControlledShutdownResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (Object topicPartitionObj : struct.getArray(PARTITIONS_REMAINING_KEY_NAME)) {
            Struct topicPartition = (Struct)topicPartitionObj;
            String topic = topicPartition.getString(TOPIC_KEY_NAME);
            int partition = topicPartition.getInt(PARTITION_KEY_NAME);
            partitions.add(new TopicPartition(topic, partition));
        }
        this.partitionsRemaining = partitions;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public Set<TopicPartition> partitionsRemaining() {
        return this.partitionsRemaining;
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer) {
        return new ControlledShutdownResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer, int version) {
        return new ControlledShutdownResponse(ProtoUtils.parseResponse(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id, version, buffer));
    }
}

