/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.kafka.v09;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.kafka.KafkaSourceCounter;
import org.apache.flume.source.AbstractPollableSource;
import org.apache.flume.source.kafka.v09.SourceRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource
extends AbstractPollableSource
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(KafkaSource.class);
    private Context context;
    private Properties kafkaProps;
    private KafkaSourceCounter counter;
    private KafkaConsumer<String, byte[]> consumer;
    private Iterator<ConsumerRecord<String, byte[]>> it;
    private final List<Event> eventList = new ArrayList<Event>();
    private Map<TopicPartition, OffsetAndMetadata> toBeCommitted;
    private AtomicBoolean rebalanceFlag;
    private Map<String, String> headers;
    private int batchUpperLimit;
    private int maxBatchDurationMillis;
    private List<String> topicList;
    private Lock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollableSource.Status doProcess() throws EventDeliveryException {
        String batchUUID = UUID.randomUUID().toString();
        try {
            long nanoBatchStartTime = System.nanoTime();
            long batchStartTime = System.currentTimeMillis();
            long batchEndTime = System.currentTimeMillis() + (long)this.maxBatchDurationMillis;
            while (this.eventList.size() < this.batchUpperLimit && System.currentTimeMillis() < batchEndTime) {
                if (this.it == null || !this.it.hasNext()) {
                    ConsumerRecords records = this.consumer.poll(Math.max(0L, batchEndTime - System.currentTimeMillis()));
                    this.it = records.iterator();
                    if (this.rebalanceFlag.get()) {
                        this.rebalanceFlag.set(false);
                        break;
                    }
                    if (!this.it.hasNext()) {
                        if (!log.isDebugEnabled()) break;
                        this.counter.incrementKafkaEmptyCount();
                        log.debug("Returning with backoff. No more data to read");
                        break;
                    }
                }
                ConsumerRecord<String, byte[]> message = this.it.next();
                byte[] kafkaMessage = (byte[])message.value();
                String kafkaKey = (String)message.key();
                this.headers.put("timestamp", String.valueOf(System.currentTimeMillis()));
                this.headers.put("topic", message.topic());
                this.headers.put("partition", String.valueOf(message.partition()));
                if (kafkaKey != null) {
                    this.headers.put("key", kafkaKey);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Message: {}", (Object)new String(kafkaMessage));
                    log.debug("Topic: {} Partition: {}", (Object)message.topic(), (Object)message.partition());
                }
                Event event = EventBuilder.withBody((byte[])kafkaMessage, this.headers);
                this.eventList.add(event);
                if (log.isDebugEnabled()) {
                    log.debug("Waited: {} ", (Object)(System.currentTimeMillis() - batchStartTime));
                    log.debug("Event #: {}", (Object)this.eventList.size());
                }
                this.toBeCommitted.put(new TopicPartition(message.topic(), message.partition()), new OffsetAndMetadata(message.offset() + 1L, batchUUID));
            }
            if (this.eventList.size() > 0) {
                this.counter.addToKafkaEventGetTimer((System.nanoTime() - nanoBatchStartTime) / 1000000L);
                this.counter.addToEventReceivedCount((long)this.eventList.size());
                this.getChannelProcessor().processEventBatch(this.eventList);
                this.counter.addToEventAcceptedCount((long)this.eventList.size());
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} events to channel", (Object)this.eventList.size());
                }
                this.eventList.clear();
                try {
                    this.lock.lock();
                    long commitStartTime = System.nanoTime();
                    this.consumer.commitSync(this.toBeCommitted);
                    long commitEndTime = System.nanoTime();
                    this.counter.addToKafkaCommitTimer((commitEndTime - commitStartTime) / 1000000L);
                    this.toBeCommitted.clear();
                }
                finally {
                    this.lock.unlock();
                }
                return PollableSource.Status.READY;
            }
            return PollableSource.Status.BACKOFF;
        }
        catch (Exception e) {
            log.error("KafkaSource EXCEPTION, {}", (Throwable)e);
            return PollableSource.Status.BACKOFF;
        }
    }

    protected void doConfigure(Context context) throws FlumeException {
        this.context = context;
        this.headers = new HashMap<String, String>(4);
        this.toBeCommitted = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.lock = new ReentrantLock();
        this.rebalanceFlag = new AtomicBoolean(false);
        String topics = context.getString("kafka.topics");
        if (topics == null) {
            throw new ConfigurationException("At least one Kafka topic must be specified.");
        }
        this.topicList = Arrays.asList(topics.split("^\\s+|\\s*,\\s*|\\s+$"));
        this.batchUpperLimit = context.getInteger("batchSize", Integer.valueOf(1000));
        this.maxBatchDurationMillis = context.getInteger("batchDurationMillis", Integer.valueOf(1000));
        String bootstrapServers = context.getString("kafka.bootstrap.servers");
        this.setConsumerProps(context, bootstrapServers);
        if (this.counter == null) {
            this.counter = new KafkaSourceCounter(this.getName());
        }
    }

    private void setConsumerProps(Context ctx, String bootStrapServers) {
        this.kafkaProps = new Properties();
        String groupId = ctx.getString("kafka.consumer.group.id");
        if (groupId == null || groupId.isEmpty()) {
            groupId = "flume";
            log.info("Group ID was not specified. Using " + groupId + " as the group id.");
        }
        this.kafkaProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.kafkaProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.kafkaProps.put("group.id", "flume");
        this.kafkaProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.consumer."));
        if (bootStrapServers != null) {
            this.kafkaProps.put("bootstrap.servers", bootStrapServers);
        }
        this.kafkaProps.put("group.id", groupId);
        this.kafkaProps.put("enable.auto.commit", "false");
        log.info(this.kafkaProps.toString());
    }

    Properties getConsumerProps() {
        return this.kafkaProps;
    }

    protected void doStart() throws FlumeException {
        log.info("Starting {}...", (Object)this);
        try {
            this.consumer = new KafkaConsumer(this.kafkaProps);
        }
        catch (Exception e) {
            throw new FlumeException("Unable to create consumer. Check whether the Bootstrap server is up and that the Flume agent can connect to it.", (Throwable)e);
        }
        this.consumer.subscribe(this.topicList, (ConsumerRebalanceListener)new SourceRebalanceListener(this.rebalanceFlag));
        this.it = this.consumer.poll(1000L).iterator();
        log.info("Kafka source {} started.", (Object)this.getName());
        this.counter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws FlumeException {
        if (this.consumer != null) {
            try {
                this.lock.lock();
                this.consumer.wakeup();
                this.consumer.close();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.counter.stop();
        log.info("Kafka Source {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
    }
}

