/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kafka.v09;

import com.google.common.base.Throwables;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.kafka.KafkaSinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.kafka.v09.SinkCallback;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaSink.class);
    private final Properties kafkaProps = new Properties();
    private KafkaProducer<String, byte[]> producer;
    private String topic;
    private int batchSize;
    private List<Future<RecordMetadata>> kafkaFutures;
    private KafkaSinkCounter counter;

    public Sink.Status process() throws EventDeliveryException {
        Sink.Status result = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction transaction = null;
        Event event = null;
        String eventTopic = null;
        String eventKey = null;
        try {
            long processedEvents;
            transaction = channel.getTransaction();
            transaction.begin();
            this.kafkaFutures.clear();
            long batchStartTime = System.nanoTime();
            for (processedEvents = 0L; processedEvents < (long)this.batchSize; ++processedEvents) {
                event = channel.take();
                if (event == null) {
                    if (processedEvents == 0L) {
                        result = Sink.Status.BACKOFF;
                        this.counter.incrementBatchEmptyCount();
                        break;
                    }
                    this.counter.incrementBatchUnderflowCount();
                    break;
                }
                byte[] eventBody = event.getBody();
                Map headers = event.getHeaders();
                eventTopic = (String)headers.get("topic");
                if (eventTopic == null) {
                    eventTopic = this.topic;
                }
                eventKey = (String)headers.get("key");
                if (logger.isDebugEnabled()) {
                    logger.debug("{Event} " + eventTopic + " : " + eventKey + " : " + new String(eventBody, "UTF-8"));
                    logger.debug("event #{}", (Object)processedEvents);
                }
                long startTime = System.currentTimeMillis();
                this.kafkaFutures.add(this.producer.send(new ProducerRecord(eventTopic, (Object)eventKey, (Object)eventBody), (Callback)new SinkCallback(startTime)));
            }
            this.producer.flush();
            if (processedEvents > 0L) {
                for (Future<RecordMetadata> future : this.kafkaFutures) {
                    future.get();
                }
                long endTime = System.nanoTime();
                this.counter.addToKafkaEventSendTimer((endTime - batchStartTime) / 1000000L);
                this.counter.addToEventDrainSuccessCount(Long.valueOf(this.kafkaFutures.size()).longValue());
            }
            transaction.commit();
        }
        catch (Exception ex) {
            String errorMsg = "Failed to publish events";
            logger.error("Failed to publish events", (Throwable)ex);
            result = Sink.Status.BACKOFF;
            if (transaction != null) {
                try {
                    this.kafkaFutures.clear();
                    transaction.rollback();
                    this.counter.incrementRollbackCount();
                }
                catch (Exception e) {
                    logger.error("Transaction rollback failed", (Throwable)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
            throw new EventDeliveryException(errorMsg, (Throwable)ex);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return result;
    }

    public synchronized void start() {
        this.producer = new KafkaProducer(this.kafkaProps);
        this.counter.start();
        super.start();
    }

    public synchronized void stop() {
        this.producer.close();
        this.counter.stop();
        logger.info("Kafka Sink {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
        super.stop();
    }

    public void configure(Context context) {
        String topicStr = context.getString("kafka.topic");
        if (topicStr == null || topicStr.isEmpty()) {
            topicStr = "default-flume-topic";
            logger.warn("Topic was not specified. Using {} as the topic.", (Object)topicStr);
        } else {
            logger.info("Using the static topic {}. This may be overridden by event headers", (Object)topicStr);
        }
        this.topic = topicStr;
        this.batchSize = context.getInteger("kafka.flumeBatchSize", Integer.valueOf(100));
        if (logger.isDebugEnabled()) {
            logger.debug("Using batch size: {}", (Object)this.batchSize);
        }
        this.kafkaFutures = new LinkedList<Future<RecordMetadata>>();
        String bootStrapServers = context.getString("kafka.bootstrap.servers");
        this.setProducerProps(context, bootStrapServers);
        if (logger.isDebugEnabled()) {
            logger.debug("Kafka producer properties: {}", (Object)this.kafkaProps);
        }
        if (this.counter == null) {
            this.counter = new KafkaSinkCounter(this.getName());
        }
    }

    private void setProducerProps(Context context, String bootStrapServers) {
        this.kafkaProps.put("acks", "1");
        this.kafkaProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.kafkaProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.kafkaProps.putAll((Map<?, ?>)context.getSubProperties("kafka.producer."));
        if (bootStrapServers != null) {
            this.kafkaProps.put("bootstrap.servers", bootStrapServers);
        }
        logger.info("Producer properties: {}", (Object)this.kafkaProps.toString());
    }

    protected Properties getKafkaProps() {
        return this.kafkaProps;
    }
}

