/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.kafka.v09;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.BasicChannelSemantics;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.flume.channel.kafka.v09.ChannelCallback;
import org.apache.flume.channel.kafka.v09.ChannelRebalanceListener;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.instrumentation.kafka.KafkaChannelCounter;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaChannel
extends BasicChannelSemantics {
    private static final Logger logger = LoggerFactory.getLogger(KafkaChannel.class);
    private final Properties consumerProps = new Properties();
    private final Properties producerProps = new Properties();
    private KafkaProducer<String, byte[]> producer;
    private final String channelUUID = UUID.randomUUID().toString();
    private AtomicReference<String> topic = new AtomicReference();
    private boolean parseAsFlumeEvent = true;
    AtomicBoolean rebalanceFlag = new AtomicBoolean();
    private long pollTimeout = 500L;
    private final List<ConsumerAndRecords> consumers = Collections.synchronizedList(new LinkedList());
    private KafkaChannelCounter counter;
    private final ThreadLocal<ConsumerAndRecords> consumerAndRecords = new ThreadLocal<ConsumerAndRecords>(){

        @Override
        public ConsumerAndRecords initialValue() {
            return KafkaChannel.this.createConsumerAndRecords();
        }
    };

    public void start() {
        try {
            logger.info("Starting Kafka Channel: {}", (Object)this.getName());
            this.producer = new KafkaProducer(this.producerProps);
            logger.info("Topic = {}", (Object)this.topic.get());
            this.counter.start();
            super.start();
        }
        catch (Exception e) {
            logger.error("Could not start producer");
            throw new FlumeException("Unable to create Kafka Connections. Check whether Kafka Brokers are up and that the Flume agent can connect to it.", (Throwable)e);
        }
    }

    public void stop() {
        for (ConsumerAndRecords c : this.consumers) {
            try {
                this.decommissionConsumerAndRecords(c);
            }
            catch (Exception ex) {
                logger.warn("Error while shutting down consumer.", (Throwable)ex);
            }
        }
        this.producer.close();
        this.counter.stop();
        super.stop();
        logger.info("Kafka channel {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.counter);
    }

    protected BasicTransactionSemantics createTransaction() {
        return new KafkaTransaction();
    }

    public void configure(Context ctx) {
        String topicStr = ctx.getString("kafka.topic");
        if (topicStr == null || topicStr.isEmpty()) {
            topicStr = "flume-channel";
            logger.info("Topic was not specified. Using {} as the topic.", (Object)topicStr);
        }
        this.topic.set(topicStr);
        String bootStrapServers = ctx.getString("kafka.bootstrap.servers");
        this.setProducerProps(ctx, bootStrapServers);
        this.setConsumerProps(ctx, bootStrapServers);
        this.parseAsFlumeEvent = ctx.getBoolean("parseAsFlumeEvent", Boolean.valueOf(true));
        this.pollTimeout = ctx.getLong("kafka.pollTimeout", Long.valueOf(500L));
        if (this.counter == null) {
            this.counter = new KafkaChannelCounter(this.getName());
        }
    }

    private void setProducerProps(Context ctx, String bootStrapServers) {
        this.producerProps.put("acks", "all");
        this.producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.producerProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.producer."));
        if (bootStrapServers != null) {
            this.producerProps.put("bootstrap.servers", bootStrapServers);
        }
        logger.info("Producer properties: " + this.producerProps.toString());
    }

    protected Properties getProducerProps() {
        return this.producerProps;
    }

    private void setConsumerProps(Context ctx, String bootStrapServers) {
        String groupId = ctx.getString("kafka.consumer.group.id");
        if (groupId == null || groupId.isEmpty()) {
            groupId = "flume";
            logger.info("Group ID was not specified. Using {} as the group id.", (Object)groupId);
        }
        this.consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.consumerProps.put("auto.offset.reset", "earliest");
        this.consumerProps.putAll((Map<?, ?>)ctx.getSubProperties("kafka.consumer."));
        if (bootStrapServers != null) {
            this.consumerProps.put("bootstrap.servers", bootStrapServers);
        }
        this.consumerProps.put("group.id", groupId);
        this.consumerProps.put("enable.auto.commit", (Object)false);
        logger.info(this.consumerProps.toString());
    }

    private synchronized ConsumerAndRecords createConsumerAndRecords() {
        try {
            KafkaConsumer consumer = new KafkaConsumer(this.consumerProps);
            ConsumerAndRecords car = new ConsumerAndRecords((KafkaConsumer<String, byte[]>)consumer, this.channelUUID);
            logger.info("Created new consumer to connect to Kafka");
            car.consumer.subscribe(Arrays.asList(this.topic.get()), (ConsumerRebalanceListener)new ChannelRebalanceListener(this.rebalanceFlag));
            car.offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            this.consumers.add(car);
            return car;
        }
        catch (Exception e) {
            throw new FlumeException("Unable to connect to Kafka", (Throwable)e);
        }
    }

    protected Properties getConsumerProps() {
        return this.consumerProps;
    }

    private void decommissionConsumerAndRecords(ConsumerAndRecords c) {
        if (c.failedEvents.isEmpty()) {
            c.commitOffsets();
        }
        c.failedEvents.clear();
        c.consumer.close();
    }

    @VisibleForTesting
    void registerThread() {
        try {
            this.consumerAndRecords.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<CharSequence, CharSequence> toCharSeqMap(Map<String, String> stringMap) {
        HashMap<CharSequence, CharSequence> charSeqMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            charSeqMap.put(entry.getKey(), entry.getValue());
        }
        return charSeqMap;
    }

    private static Map<String, String> toStringMap(Map<CharSequence, CharSequence> charSeqMap) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        for (Map.Entry<CharSequence, CharSequence> entry : charSeqMap.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    private class ConsumerAndRecords {
        final KafkaConsumer<String, byte[]> consumer;
        final String uuid;
        final LinkedList<Event> failedEvents = new LinkedList();
        ConsumerRecords<String, byte[]> records;
        Iterator<ConsumerRecord<String, byte[]>> recordIterator;
        Map<TopicPartition, OffsetAndMetadata> offsets;

        ConsumerAndRecords(KafkaConsumer<String, byte[]> consumer, String uuid) {
            this.consumer = consumer;
            this.uuid = uuid;
            this.records = ConsumerRecords.empty();
            this.recordIterator = this.records.iterator();
        }

        void poll() {
            this.records = this.consumer.poll(KafkaChannel.this.pollTimeout);
            this.recordIterator = this.records.iterator();
            logger.trace("polling");
        }

        void commitOffsets() {
            this.consumer.commitSync(this.offsets);
        }

        public void printCurrentAssignment() {
            StringBuilder sb = new StringBuilder();
            for (TopicPartition tp : this.consumer.assignment()) {
                try {
                    sb.append("Committed: [").append(tp).append(",").append(this.consumer.committed(tp).offset()).append(",").append(this.consumer.committed(tp).metadata()).append("]");
                    logger.info(sb.toString());
                }
                catch (NullPointerException npe) {
                    logger.info("Committed {}", (Object)tp);
                }
                catch (UnknownTopicOrPartitionException e) {
                    logger.info("Committed {}", (Object)tp);
                }
            }
        }
    }

    private class KafkaTransaction
    extends BasicTransactionSemantics {
        private TransactionType type = TransactionType.NONE;
        private Optional<ByteArrayOutputStream> tempOutStream = Optional.absent();
        private Optional<LinkedList<ProducerRecord<String, byte[]>>> producerRecords = Optional.absent();
        private Optional<LinkedList<Event>> events = Optional.absent();
        private Optional<SpecificDatumWriter<AvroFlumeEvent>> writer = Optional.absent();
        private Optional<SpecificDatumReader<AvroFlumeEvent>> reader = Optional.absent();
        private Optional<LinkedList<Future<RecordMetadata>>> kafkaFutures = Optional.absent();
        private final String batchUUID = UUID.randomUUID().toString();
        private BinaryEncoder encoder = null;
        private BinaryDecoder decoder = null;
        private boolean eventTaken = false;

        private KafkaTransaction() {
        }

        protected void doBegin() throws InterruptedException {
            KafkaChannel.this.rebalanceFlag.set(false);
        }

        protected void doPut(Event event) throws InterruptedException {
            this.type = TransactionType.PUT;
            if (!this.producerRecords.isPresent()) {
                this.producerRecords = Optional.of(new LinkedList());
            }
            String key = (String)event.getHeaders().get("key");
            try {
                ((LinkedList)this.producerRecords.get()).add(new ProducerRecord((String)KafkaChannel.this.topic.get(), (Object)key, (Object)this.serializeValue(event, KafkaChannel.this.parseAsFlumeEvent)));
            }
            catch (Exception e) {
                throw new ChannelException("Error while serializing event", (Throwable)e);
            }
        }

        protected Event doTake() throws InterruptedException {
            Event e;
            this.type = TransactionType.TAKE;
            try {
                if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).uuid.equals(KafkaChannel.this.channelUUID)) {
                    logger.info("UUID mismatch, creating new consumer");
                    KafkaChannel.this.decommissionConsumerAndRecords((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get());
                    KafkaChannel.this.consumerAndRecords.remove();
                }
            }
            catch (Exception ex) {
                logger.warn("Error while shutting down consumer", (Throwable)ex);
            }
            if (!this.events.isPresent()) {
                this.events = Optional.of(new LinkedList());
            }
            if (KafkaChannel.this.rebalanceFlag.get()) {
                logger.debug("Returning null event after Consumer rebalance.");
                return null;
            }
            if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.isEmpty()) {
                e = ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.removeFirst();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Assigment: {}", (Object)((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).consumer.assignment().toString());
                }
                try {
                    long startTime = System.nanoTime();
                    if (!((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.hasNext()) {
                        ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).poll();
                    }
                    if (((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.hasNext()) {
                        ConsumerRecord<String, byte[]> record = ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).recordIterator.next();
                        e = this.deserializeValue((byte[])record.value(), KafkaChannel.this.parseAsFlumeEvent);
                        TopicPartition tp = new TopicPartition(record.topic(), record.partition());
                        OffsetAndMetadata oam = new OffsetAndMetadata(record.offset() + 1L, this.batchUUID);
                        ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).offsets.put(tp, oam);
                        if (logger.isTraceEnabled()) {
                            logger.trace("Took offset: {}", (Object)((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).offsets.toString());
                        }
                        e.getHeaders().put("key", record.key());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Processed output from partition {} offset {}", (Object)record.partition(), (Object)record.offset());
                        }
                    } else {
                        return null;
                    }
                    long endTime = System.nanoTime();
                    KafkaChannel.this.counter.addToKafkaEventGetTimer((endTime - startTime) / 1000000L);
                }
                catch (Exception ex) {
                    logger.warn("Error while getting events from Kafka. This is usually caused by trying to read a non-flume event. Ensure the setting for parseAsFlumeEvent is correct", (Throwable)ex);
                    throw new ChannelException("Error while getting events from Kafka", (Throwable)ex);
                }
            }
            this.eventTaken = true;
            ((LinkedList)this.events.get()).add(e);
            return e;
        }

        protected void doCommit() throws InterruptedException {
            if (this.type.equals((Object)TransactionType.NONE)) {
                return;
            }
            if (this.type.equals((Object)TransactionType.PUT)) {
                if (!this.kafkaFutures.isPresent()) {
                    this.kafkaFutures = Optional.of(new LinkedList());
                }
                try {
                    long batchSize = ((LinkedList)this.producerRecords.get()).size();
                    long startTime = System.nanoTime();
                    int index = 0;
                    for (ProducerRecord record : (LinkedList)this.producerRecords.get()) {
                        ((LinkedList)this.kafkaFutures.get()).add(KafkaChannel.this.producer.send(record, (Callback)new ChannelCallback(++index, startTime)));
                    }
                    KafkaChannel.this.producer.flush();
                    for (Future future : (LinkedList)this.kafkaFutures.get()) {
                        future.get();
                    }
                    long endTime = System.nanoTime();
                    KafkaChannel.this.counter.addToKafkaEventSendTimer((endTime - startTime) / 1000000L);
                    KafkaChannel.this.counter.addToEventPutSuccessCount(batchSize);
                    ((LinkedList)this.producerRecords.get()).clear();
                    ((LinkedList)this.kafkaFutures.get()).clear();
                }
                catch (Exception ex) {
                    logger.warn("Sending events to Kafka failed", (Throwable)ex);
                    throw new ChannelException("Commit failed as send to Kafka failed", (Throwable)ex);
                }
            } else {
                if (((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.isEmpty() && this.eventTaken) {
                    long startTime = System.nanoTime();
                    ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).commitOffsets();
                    long endTime = System.nanoTime();
                    KafkaChannel.this.counter.addToKafkaCommitTimer((endTime - startTime) / 1000000L);
                    ((ConsumerAndRecords)KafkaChannel.this.consumerAndRecords.get()).printCurrentAssignment();
                }
                KafkaChannel.this.counter.addToEventTakeSuccessCount(Long.valueOf(((LinkedList)this.events.get()).size()).longValue());
                ((LinkedList)this.events.get()).clear();
            }
        }

        protected void doRollback() throws InterruptedException {
            if (this.type.equals((Object)TransactionType.NONE)) {
                return;
            }
            if (this.type.equals((Object)TransactionType.PUT)) {
                ((LinkedList)this.producerRecords.get()).clear();
                ((LinkedList)this.kafkaFutures.get()).clear();
            } else {
                KafkaChannel.this.counter.addToRollbackCounter(Long.valueOf(((LinkedList)this.events.get()).size()).longValue());
                ((ConsumerAndRecords)((KafkaChannel)KafkaChannel.this).consumerAndRecords.get()).failedEvents.addAll((Collection)this.events.get());
                ((LinkedList)this.events.get()).clear();
            }
        }

        private byte[] serializeValue(Event event, boolean parseAsFlumeEvent) throws IOException {
            byte[] bytes;
            if (parseAsFlumeEvent) {
                if (!this.tempOutStream.isPresent()) {
                    this.tempOutStream = Optional.of((Object)new ByteArrayOutputStream());
                }
                if (!this.writer.isPresent()) {
                    this.writer = Optional.of((Object)new SpecificDatumWriter(AvroFlumeEvent.class));
                }
                ((ByteArrayOutputStream)this.tempOutStream.get()).reset();
                AvroFlumeEvent e = new AvroFlumeEvent(KafkaChannel.toCharSeqMap(event.getHeaders()), ByteBuffer.wrap(event.getBody()));
                this.encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)this.tempOutStream.get(), this.encoder);
                ((SpecificDatumWriter)this.writer.get()).write((Object)e, (Encoder)this.encoder);
                this.encoder.flush();
                bytes = ((ByteArrayOutputStream)this.tempOutStream.get()).toByteArray();
            } else {
                bytes = event.getBody();
            }
            return bytes;
        }

        private Event deserializeValue(byte[] value, boolean parseAsFlumeEvent) throws IOException {
            Event e;
            if (parseAsFlumeEvent) {
                ByteArrayInputStream in = new ByteArrayInputStream(value);
                this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)in, this.decoder);
                if (!this.reader.isPresent()) {
                    this.reader = Optional.of((Object)new SpecificDatumReader(AvroFlumeEvent.class));
                }
                AvroFlumeEvent event = (AvroFlumeEvent)((SpecificDatumReader)this.reader.get()).read(null, (Decoder)this.decoder);
                e = EventBuilder.withBody((byte[])event.getBody().array(), (Map)KafkaChannel.toStringMap(event.getHeaders()));
            } else {
                e = EventBuilder.withBody((byte[])value, (Map)Collections.EMPTY_MAP);
            }
            return e;
        }
    }

    private static enum TransactionType {
        PUT,
        TAKE,
        NONE;

    }
}

