/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredCounterGroup {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredCounterGroup.class);
    private static final String COUNTER_GROUP_START_TIME = "start.time";
    private static final String COUNTER_GROUP_STOP_TIME = "stop.time";
    private final Type type;
    private final String name;
    private final Map<String, AtomicLong> counterMap;
    private AtomicLong startTime;
    private AtomicLong stopTime;
    private volatile boolean registered = false;

    protected MonitoredCounterGroup(Type type, String name, String ... attrs) {
        this.type = type;
        this.name = name;
        HashMap<String, AtomicLong> counterInitMap = new HashMap<String, AtomicLong>();
        for (String attribute : attrs) {
            counterInitMap.put(attribute, new AtomicLong(0L));
        }
        this.counterMap = Collections.unmodifiableMap(counterInitMap);
        this.startTime = new AtomicLong(0L);
        this.stopTime = new AtomicLong(0L);
    }

    public void start() {
        this.register();
        this.stopTime.set(0L);
        for (String counter : this.counterMap.keySet()) {
            this.counterMap.get(counter).set(0L);
        }
        this.startTime.set(System.currentTimeMillis());
        logger.info("Component type: " + (Object)((Object)this.type) + ", name: " + this.name + " started");
    }

    @VisibleForTesting
    void register() {
        if (!this.registered) {
            try {
                ObjectName objName = new ObjectName("org.apache.flume." + this.type.name().toLowerCase(Locale.ENGLISH) + ":type=" + this.name);
                if (ManagementFactory.getPlatformMBeanServer().isRegistered(objName)) {
                    logger.debug("Monitored counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name + ": Another MBean is already registered with this name. " + "Unregistering that pre-existing MBean now...");
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(objName);
                    logger.debug("Monitored counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name + ": Successfully unregistered pre-existing MBean.");
                }
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, objName);
                logger.info("Monitored counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name + ": Successfully registered new MBean.");
                this.registered = true;
            }
            catch (Exception ex) {
                logger.error("Failed to register monitored counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name, (Throwable)ex);
            }
        }
    }

    public void stop() {
        this.stopTime.set(System.currentTimeMillis());
        logger.info("Component type: " + (Object)((Object)this.type) + ", name: " + this.name + " stopped");
        String typePrefix = this.type.name().toLowerCase(Locale.ENGLISH);
        logger.info("Shutdown Metric for type: " + (Object)((Object)this.type) + ", " + "name: " + this.name + ". " + typePrefix + "." + COUNTER_GROUP_START_TIME + " == " + this.startTime);
        logger.info("Shutdown Metric for type: " + (Object)((Object)this.type) + ", " + "name: " + this.name + ". " + typePrefix + "." + COUNTER_GROUP_STOP_TIME + " == " + this.stopTime);
        ArrayList<String> mapKeys = new ArrayList<String>(this.counterMap.keySet());
        Collections.sort(mapKeys);
        for (String counterMapKey : mapKeys) {
            long counterMapValue = this.get(counterMapKey);
            logger.info("Shutdown Metric for type: " + (Object)((Object)this.type) + ", " + "name: " + this.name + ". " + counterMapKey + " == " + counterMapValue);
        }
    }

    public long getStartTime() {
        return this.startTime.get();
    }

    public long getStopTime() {
        return this.stopTime.get();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.type.name()).append(":");
        sb.append(this.name).append("{");
        boolean first = true;
        Iterator<String> counterIterator = this.counterMap.keySet().iterator();
        while (counterIterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String counterName = counterIterator.next();
            sb.append(counterName).append("=").append(this.get(counterName));
        }
        sb.append("}");
        return sb.toString();
    }

    protected long get(String counter) {
        return this.counterMap.get(counter).get();
    }

    protected void set(String counter, long value) {
        this.counterMap.get(counter).set(value);
    }

    protected long addAndGet(String counter, long delta) {
        return this.counterMap.get(counter).addAndGet(delta);
    }

    protected long increment(String counter) {
        return this.counterMap.get(counter).incrementAndGet();
    }

    public String getType() {
        return this.type.name();
    }

    public static enum Type {
        SOURCE,
        CHANNEL_PROCESSOR,
        CHANNEL,
        SINK_PROCESSOR,
        SINK,
        INTERCEPTOR,
        SERIALIZER,
        OTHER;

    }
}

