/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.filters;

import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.hbase.filters.EntityFilter;
import org.kitesdk.data.hbase.impl.EntitySchema;
import org.kitesdk.data.hbase.impl.EntitySerDe;

public class SingleFieldEntityFilter
implements EntityFilter {
    private final Filter filter;

    public SingleFieldEntityFilter(EntitySchema entitySchema, EntitySerDe<?> entitySerDe, String fieldName, Object filterValue) {
        this(entitySchema, entitySerDe, fieldName, filterValue, CompareFilter.CompareOp.EQUAL);
    }

    public SingleFieldEntityFilter(EntitySchema entitySchema, EntitySerDe<?> entitySerDe, String fieldName, Object filterValue, CompareFilter.CompareOp equalityOperator) {
        FieldMapping fieldMapping = entitySchema.getColumnMappingDescriptor().getFieldMapping(fieldName);
        if (fieldMapping.getMappingType() != FieldMapping.MappingType.COLUMN) {
            throw new DatasetException("SingleColumnValueFilter only compatible with COLUMN mapping types.");
        }
        byte[] family = fieldMapping.getFamily();
        byte[] qualifier = fieldMapping.getQualifier();
        byte[] comparisonBytes = entitySerDe.serializeColumnValueToBytes(fieldName, filterValue);
        this.filter = new SingleColumnValueFilter(family, qualifier, equalityOperator, comparisonBytes);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }
}

