/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroSerialization;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.kitesdk.compat.DynMethods;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;
import org.kitesdk.data.spi.AbstractKeyRecordReaderWrapper;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.FilteredRecordReader;
import org.kitesdk.data.spi.filesystem.CSVInputFormat;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.InputFormatUtil;
import org.kitesdk.data.spi.filesystem.JSONInputFormat;
import org.kitesdk.data.spi.filesystem.ValueReaderWrapper;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;

class FileSystemViewKeyInputFormat<E>
extends InputFormat<E, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemViewKeyInputFormat.class);
    private static final String AVRO_SCHEMA_INPUT_KEY = "avro.schema.input.key";
    private static final DynMethods.StaticMethod setModel = new DynMethods.Builder("setDataModelClass").impl(AvroSerialization.class, new Class[]{Configuration.class, Class.class}).defaultNoop().buildStatic();
    private FileSystemDataset<E> dataset;
    private FileSystemView<E> view;

    public FileSystemViewKeyInputFormat(FileSystemDataset<E> dataset, Configuration conf) {
        this.dataset = dataset;
        LOG.debug("Dataset: {}", dataset);
        Format format = dataset.getDescriptor().getFormat();
        boolean isSpecific = SpecificRecord.class.isAssignableFrom(dataset.getType());
        if (Formats.AVRO.equals(format)) {
            setModel.invoke(new Object[]{conf, DataModelUtil.getDataModelForType(dataset.getType()).getClass()});
            if (isSpecific) {
                conf.set(AVRO_SCHEMA_INPUT_KEY, SpecificData.get().getSchema(dataset.getType()).toString());
            }
        } else if (Formats.PARQUET.equals(format) && isSpecific) {
            AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)SpecificData.get().getSchema(dataset.getType()));
        }
    }

    public FileSystemViewKeyInputFormat(FileSystemView<E> view, Configuration conf) {
        this((FileSystemDataset)view.getDataset(), conf);
        this.view = view;
        LOG.debug("View: {}", view);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        Job job = new Job(conf);
        Format format = this.dataset.getDescriptor().getFormat();
        if (this.setInputPaths(jobContext, job)) {
            if (Formats.AVRO.equals(format)) {
                AvroJob.setInputKeySchema((Job)job, (Schema)this.dataset.getDescriptor().getSchema());
                AvroKeyInputFormat delegate = new AvroKeyInputFormat();
                return delegate.getSplits(jobContext);
            }
            if (Formats.PARQUET.equals(format)) {
                AvroParquetInputFormat delegate = new AvroParquetInputFormat();
                return delegate.getSplits(jobContext);
            }
            if (Formats.JSON.equals(format)) {
                return new JSONInputFormat().getSplits(jobContext);
            }
            if (Formats.CSV.equals(format)) {
                return new CSVInputFormat().getSplits(jobContext);
            }
            if (Formats.INPUTFORMAT.equals(format)) {
                return InputFormatUtil.newInputFormatInstance(this.dataset.getDescriptor()).getSplits(jobContext);
            }
            throw new UnsupportedOperationException("Not a supported format: " + format);
        }
        return ImmutableList.of();
    }

    private boolean setInputPaths(JobContext jobContext, Job job) throws IOException {
        ArrayList<Path> paths = Lists.newArrayList(this.view == null ? this.dataset.pathIterator() : this.view.pathIterator());
        LOG.debug("Input paths: {}", paths);
        if (paths.isEmpty()) {
            return false;
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])paths.toArray(new Path[paths.size()]));
        Configuration contextConf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        Configuration jobConf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]);
        contextConf.set("mapred.input.dir", jobConf.get("mapred.input.dir"));
        return true;
    }

    public RecordReader<E, Void> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        RecordReader<E, Void> unfilteredRecordReader = this.createUnfilteredRecordReader(inputSplit, taskAttemptContext);
        if (this.view != null) {
            return new FilteredRecordReader<E>(unfilteredRecordReader, this.view.getConstraints(), this.view.getAccessor());
        }
        return unfilteredRecordReader;
    }

    private RecordReader<E, Void> createUnfilteredRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Format format = this.dataset.getDescriptor().getFormat();
        if (Formats.AVRO.equals(format)) {
            return new AvroKeyReaderWrapper(new AvroKeyInputFormat());
        }
        if (Formats.PARQUET.equals(format)) {
            return new ValueReaderWrapper(new AvroParquetInputFormat());
        }
        if (Formats.JSON.equals(format)) {
            JSONInputFormat delegate = new JSONInputFormat();
            delegate.setDescriptor(this.dataset.getDescriptor());
            delegate.setType(this.dataset.getType());
            return delegate.createRecordReader(inputSplit, taskAttemptContext);
        }
        if (Formats.CSV.equals(format)) {
            CSVInputFormat delegate = new CSVInputFormat();
            delegate.setDescriptor(this.dataset.getDescriptor());
            delegate.setType(this.dataset.getType());
            return delegate.createRecordReader(inputSplit, taskAttemptContext);
        }
        if (Formats.INPUTFORMAT.equals(format)) {
            return InputFormatUtil.newRecordReader(this.dataset.getDescriptor());
        }
        throw new UnsupportedOperationException("Not a supported format: " + format);
    }

    private static class AvroKeyReaderWrapper<E>
    extends AbstractKeyRecordReaderWrapper<E, AvroKey<E>, NullWritable> {
        public AvroKeyReaderWrapper(AvroKeyInputFormat<E> inputFormat) {
            super(inputFormat);
        }

        public E getCurrentKey() throws IOException, InterruptedException {
            return (E)((AvroKey)this.delegate.getCurrentKey()).datum();
        }
    }
}

